/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployment.orchestrator;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.xebialabs.deployit.deployment.orchestrator.DefaultOrchestrator;
import com.xebialabs.deployit.plugin.api.deployment.execution.Plan;
import com.xebialabs.deployit.plugin.api.deployment.execution.Plans;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.CompositePackage;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.Version;
import com.xebialabs.deployit.server.api.orchestrator.Orchestrator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@Orchestrator.Metadata(name="composite-package")
public class CompositePackageOrchestrator
implements Orchestrator {
    public Plan orchestrate(DeltaSpecification specification) {
        Version version = specification.getDeployedApplication().getVersion();
        if (version instanceof CompositePackage) {
            CompositePackage p = (CompositePackage)version;
            final ArrayList ids = Lists.newArrayList((Iterable)Lists.transform((List)p.getPackages(), (Function)new Function<Version, String>(){

                public String apply(Version input) {
                    return input.getId();
                }
            }));
            if (specification.getOperation() == Operation.DESTROY) {
                Collections.reverse(ids);
            }
            final ImmutableListMultimap index = Multimaps.index((Iterable)specification.getDeltas(), (Function)new Function<Delta, String>(){

                public String apply(Delta input) {
                    final String id = CompositePackageOrchestrator.this.getDeployed(input).getDeployable().getId();
                    Collection filter = Collections2.filter((Collection)ids, (Predicate)new Predicate<String>(){

                        public boolean apply(String input) {
                            return id.startsWith(input);
                        }
                    });
                    if (filter.isEmpty() || filter.size() > 1) {
                        throw new IllegalStateException(String.format("Found no or more than 1 DeploymentPackage (%s) which could have been the source of [%s]", filter, id));
                    }
                    return (String)Iterables.get((Iterable)filter, (int)0);
                }
            });
            return Plans.serial((List)Lists.transform((List)ids, (Function)new Function<String, Plan>(){

                public Plan apply(String input) {
                    return Plans.interleaved((List)index.get((Object)input));
                }
            }));
        }
        return new DefaultOrchestrator().orchestrate(specification);
    }

    private Deployed<?, ?> getDeployed(Delta input) {
        return input.getDeployed() != null ? input.getDeployed() : input.getPrevious();
    }
}

