/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.reflect;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.SyntheticHelper;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class DescriptorRegistry {
    private static final Map<Type, Descriptor> descriptors = Maps.newHashMap();
    private static final Multimap<Type, Type> subtypes = HashMultimap.create();
    private static Logger logger = LoggerFactory.getLogger(DescriptorRegistry.class);

    static void register(Class<? extends ConfigurationItem> ci) {
        Descriptor descriptor = Descriptor.from(ci);
        logger.debug("Found ConfigurationItem: {}", (Object)descriptor);
        DescriptorRegistry.register(descriptor);
    }

    static void register(Descriptor descriptor) {
        Preconditions.checkState((!descriptors.containsKey(descriptor.getType()) ? 1 : 0) != 0, (String)"The type [%s] is already registered in Deployit.", (Object[])new Object[]{descriptor.getType()});
        descriptors.put(descriptor.getType(), descriptor);
    }

    static void registerSyntheticTypeDefinition(Element syntheticElement) {
        Descriptor descriptor = Descriptor.from(syntheticElement);
        logger.debug("Found ConfigurationItem: {}", (Object)descriptor);
        DescriptorRegistry.register(descriptor);
    }

    static void registerSyntheticTypeModification(Element typeModificationElement) {
        String typeName = SyntheticHelper.getRequiredStringAttribute(typeModificationElement, "type");
        Descriptor d = DescriptorRegistry.getDescriptor(typeName);
        d.parseTypeModification(typeModificationElement);
    }

    static void registerSubtype(Type supertype, Type subtype) {
        Preconditions.checkState((!supertype.equals(subtype) ? 1 : 0) != 0, (String)"Type %s cannot be registered as its own subtype", (Object[])new Object[]{supertype});
        subtypes.put((Object)supertype, (Object)subtype);
    }

    public static Collection<Descriptor> getDescriptors() {
        return Collections.unmodifiableCollection(descriptors.values());
    }

    public static Collection<Type> getSubtypes(Type supertype) {
        return Collections.unmodifiableCollection(subtypes.get((Object)supertype));
    }

    public static Descriptor getDescriptor(String prefixedName) {
        return DescriptorRegistry.getDescriptor(Type.valueOf(prefixedName));
    }

    public static Descriptor getDescriptor(String prefix, String name) {
        return DescriptorRegistry.getDescriptor(Type.valueOf(prefix, name));
    }

    public static Descriptor getDescriptor(Type type) {
        Preconditions.checkState((!descriptors.isEmpty() ? 1 : 0) != 0, (Object)"DescriptorRegistry not booted");
        Preconditions.checkArgument((boolean)DescriptorRegistry.exists(type), (String)"Unknown type [%s]", (Object[])new Object[]{type});
        return descriptors.get(type);
    }

    public static boolean exists(Type type) {
        return descriptors.containsKey(type);
    }
}

