/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.reflect;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.SyntheticHelper;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SyntheticInitializer {
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = SyntheticInitializer.createDocumentBuilderFactory();
    private static final Logger logger = LoggerFactory.getLogger(SyntheticInitializer.class);

    public static void init() {
        SyntheticInitializer.scanSynthetic();
    }

    static void scanSynthetic() {
        try {
            ArrayList typeDefinitionElements = Lists.newArrayList();
            ArrayList typeModificationElements = Lists.newArrayList();
            SyntheticInitializer.readSynthetics("synthetic.xml", typeDefinitionElements, typeModificationElements);
            SyntheticInitializer.readSynthetics("synthetic-test.xml", typeDefinitionElements, typeModificationElements);
            SyntheticInitializer.parseAllSyntheticTypeDefinitions(typeDefinitionElements);
            SyntheticInitializer.parseAllSyntheticTypeModifications(typeModificationElements);
        }
        catch (IOException exc) {
            throw new RuntimeException("Cannot read synthetic configurations", exc);
        }
    }

    private static void readSynthetics(String name, List<Element> typeDefinitionElements, List<Element> typeModificationElements) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> syntheticXMLs = cl.getResources(name);
        while (syntheticXMLs.hasMoreElements()) {
            URL syntheticXML = syntheticXMLs.nextElement();
            Element docElement = SyntheticInitializer.readSyntheticDocument(syntheticXML).getDocumentElement();
            Iterators.addAll(typeDefinitionElements, SyntheticHelper.childByName(docElement, (Predicate<String>)Predicates.equalTo((Object)"type")));
            Iterators.addAll(typeModificationElements, SyntheticHelper.childByName(docElement, (Predicate<String>)Predicates.equalTo((Object)"type-modification")));
        }
    }

    protected static void parseAllSyntheticTypeDefinitions(List<Element> typeElements) {
        for (Element e : typeElements) {
            DescriptorRegistry.registerSyntheticTypeDefinition(e);
        }
    }

    protected static void parseAllSyntheticTypeModifications(List<Element> typeModificationElements) {
        for (Element e : typeModificationElements) {
            DescriptorRegistry.registerSyntheticTypeModification(e);
        }
    }

    private static DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory documentBuilderFactory;
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema syntheticSchema = schemaFactory.newSchema(Thread.currentThread().getContextClassLoader().getResource("synthetic.xsd"));
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setSchema(syntheticSchema);
        }
        catch (SAXException exc) {
            throw new RuntimeException("Cannot read schema synthetic.xsd", exc);
        }
        return documentBuilderFactory;
    }

    private static Document readSyntheticDocument(final URL syntheticXML) throws IOException {
        InputStream syntheticXMLStream = syntheticXML.openStream();
        try {
            final boolean[] validationErrorsFound = new boolean[1];
            DocumentBuilder builder = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exc) throws SAXException {
                    logger.warn("Warning while parsing " + syntheticXML, (Throwable)exc);
                }

                @Override
                public void error(SAXParseException exc) throws SAXException {
                    logger.error("Error while parsing " + syntheticXML, (Throwable)exc);
                    validationErrorsFound[0] = true;
                }

                @Override
                public void fatalError(SAXParseException exc) throws SAXException {
                    logger.error("Fatal error while parsing " + syntheticXML, (Throwable)exc);
                    validationErrorsFound[0] = true;
                }
            });
            Document doc = builder.parse(syntheticXMLStream);
            if (validationErrorsFound[0]) {
                throw new RuntimeException("One or more errors were found while parsing " + syntheticXML);
            }
            Document document = doc;
            return document;
        }
        catch (RuntimeException exc) {
            throw new RuntimeException("Cannot read synthetic configuration " + syntheticXML, exc);
        }
        catch (ParserConfigurationException exc) {
            throw new RuntimeException("Cannot read synthetic configuration " + syntheticXML, exc);
        }
        catch (SAXException exc) {
            throw new RuntimeException("Cannot read synthetic configuration " + syntheticXML, exc);
        }
        finally {
            Closeables.closeQuietly((Closeable)syntheticXMLStream);
        }
    }
}

