/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.text.NFRuleSet;
import com.ibm.icu.text.NFSubstitution;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.RuleBasedNumberFormat;
import java.text.ParsePosition;

class FractionalPartSubstitution
extends NFSubstitution {
    private static final String copyrightNotice = "Copyright \u00a91997-1998 IBM Corp.  All rights reserved.";
    private boolean byDigits = false;
    private boolean useSpaces = true;
    private static final int MAXDECIMALDIGITS = 8;

    FractionalPartSubstitution(int pos, NFRuleSet ruleSet, RuleBasedNumberFormat formatter, String description) {
        super(pos, ruleSet, formatter, description);
        if (description.equals(">>") || description.equals(">>>") || ruleSet == this.ruleSet) {
            this.byDigits = true;
            if (description.equals(">>>")) {
                this.useSpaces = false;
            }
        } else {
            this.ruleSet.makeIntoFractionRuleSet();
        }
    }

    public void doSubstitution(double number, StringBuffer toInsertInto, int pos) {
        if (!this.byDigits) {
            super.doSubstitution(number, toInsertInto, pos);
        } else {
            int numberToFormat = (int)Math.round(this.transformNumber(number) * Math.pow(10.0, 8.0));
            boolean doZeros = false;
            int i = 0;
            while (i < 8) {
                int digit = numberToFormat % 10;
                if (digit != 0 || doZeros) {
                    if (doZeros && this.useSpaces) {
                        toInsertInto.insert(pos + this.pos, ' ');
                    }
                    doZeros = true;
                    this.ruleSet.format(digit, toInsertInto, pos + this.pos);
                }
                numberToFormat /= 10;
                ++i;
            }
        }
    }

    public long transformNumber(long number) {
        return 0L;
    }

    public double transformNumber(double number) {
        return number - Math.floor(number);
    }

    public Number doParse(String text, ParsePosition parsePosition, double baseValue, double upperBound, boolean lenientParse) {
        if (!this.byDigits) {
            return super.doParse(text, parsePosition, baseValue, 0.0, lenientParse);
        }
        String workText = new String(text);
        ParsePosition workPos = new ParsePosition(1);
        double result = 0.0;
        double p10 = 0.1;
        while (workText.length() > 0 && workPos.getIndex() != 0) {
            workPos.setIndex(0);
            int digit = this.ruleSet.parse(workText, workPos, 10.0).intValue();
            if (lenientParse && workPos.getIndex() == 0) {
                digit = NumberFormat.getInstance().parse(workText, workPos).intValue();
            }
            if (workPos.getIndex() == 0) continue;
            result += (double)digit * p10;
            p10 /= 10.0;
            parsePosition.setIndex(parsePosition.getIndex() + workPos.getIndex());
            workText = workText.substring(workPos.getIndex());
            while (workText.length() > 0 && workText.charAt(0) == ' ') {
                workText = workText.substring(1);
                parsePosition.setIndex(parsePosition.getIndex() + 1);
            }
        }
        result = this.composeRuleValue(result, baseValue);
        return new Double(result);
    }

    public double composeRuleValue(double newRuleValue, double oldRuleValue) {
        return newRuleValue + oldRuleValue;
    }

    public double calcUpperBound(double oldUpperBound) {
        return 0.0;
    }

    char tokenChar() {
        return '>';
    }
}

