/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.cifs.winrm;

import com.google.common.base.Preconditions;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.cifs.CifsConnection;
import com.xebialabs.overthere.cifs.CifsConnectionBuilder;
import com.xebialabs.overthere.cifs.WinrmHttpsCertificateTrustStrategy;
import com.xebialabs.overthere.cifs.WinrmHttpsHostnameVerificationStrategy;
import com.xebialabs.overthere.cifs.winrm.WinRmClient;
import com.xebialabs.overthere.cifs.winrm.connector.ApacheHttpComponentsHttpClientHttpConnector;
import com.xebialabs.overthere.cifs.winrm.exception.WinRMRuntimeIOException;
import com.xebialabs.overthere.spi.AddressPortMapper;
import java.net.MalformedURLException;
import java.net.URL;

public class CifsWinRmConnection
extends CifsConnection {
    private final WinRmClient winRmClient;

    public CifsWinRmConnection(String type, ConnectionOptions options, AddressPortMapper mapper) {
        super(type, options, mapper, false);
        Preconditions.checkArgument((this.os == OperatingSystemFamily.WINDOWS ? 1 : 0) != 0, (String)"Cannot start a cifs:%s connection to a non-Windows operating system", (Object[])new Object[]{this.cifsConnectionType.toString().toLowerCase()});
        URL targetURL = this.getTargetURL(options);
        ApacheHttpComponentsHttpClientHttpConnector httpConnector = this.createHttpConnector(targetURL, options);
        this.winRmClient = this.createWinrmClient(targetURL, httpConnector, options);
    }

    private URL getTargetURL(ConnectionOptions options) {
        String scheme = options.getBoolean("winrmEnableHttps", false) ? "https" : "http";
        String context = options.get("winrmContext", "/wsman");
        try {
            return new URL(scheme, this.address, this.port, context);
        }
        catch (MalformedURLException e) {
            throw new WinRMRuntimeIOException("Cannot build a new URL for " + this, e);
        }
    }

    private ApacheHttpComponentsHttpClientHttpConnector createHttpConnector(URL targetURL, ConnectionOptions options) {
        ApacheHttpComponentsHttpClientHttpConnector httpConnector = new ApacheHttpComponentsHttpClientHttpConnector(this.username, this.password, targetURL);
        httpConnector.setHttpsCertTrustStrategy(options.getEnum("winrmHttpsCertificateTrustStrategy", WinrmHttpsCertificateTrustStrategy.class, CifsConnectionBuilder.DEFAULT_WINRM_HTTPS_CERTIFICATE_TRUST_STRATEGY));
        httpConnector.setHttpsHostnameVerifyStrategy(options.getEnum("winrmHttpsHostnameVerificationStrategy", WinrmHttpsHostnameVerificationStrategy.class, CifsConnectionBuilder.DEFAULT_WINRM_HTTPS_HOSTNAME_VERIFICATION_STRATEGY));
        httpConnector.setDebugKerberosAuth(options.getBoolean("winrmDebugKerberosAuth", false));
        return httpConnector;
    }

    private WinRmClient createWinrmClient(URL targetURL, ApacheHttpComponentsHttpClientHttpConnector httpConnector, ConnectionOptions options) {
        WinRmClient client = new WinRmClient(httpConnector, targetURL);
        client.setTimeout(options.get("winrmTimeout", "PT60.000S"));
        client.setEnvelopSize(options.get("winrmEnvelopSize", 153600));
        client.setLocale(options.get("winrmLocale", "en-US"));
        return client;
    }

    @Override
    public int execute(OverthereProcessOutputHandler handler, CmdLine commandLine) {
        String cmd = commandLine.toCommandLine(this.getHostOperatingSystem(), false);
        if (this.workingDirectory != null) {
            cmd = "CD " + this.workingDirectory.getPath() + " & " + cmd;
        }
        this.winRmClient.runCmd(cmd, handler);
        return this.winRmClient.getExitCode();
    }
}

