/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.local;

import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.Overthere;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.spi.BaseOverthereConnection;
import com.xebialabs.overthere.spi.OverthereConnectionBuilder;
import com.xebialabs.overthere.spi.Protocol;
import com.xebialabs.overthere.util.DefaultAddressPortMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Protocol(name="local")
public class LocalConnection
extends BaseOverthereConnection
implements OverthereConnectionBuilder {
    public static final String LOCAL_PROTOCOL = "local";
    private static final Logger logger = LoggerFactory.getLogger(LocalConnection.class);

    public LocalConnection(String protocol, ConnectionOptions options, AddressPortMapper mapper) {
        super(protocol, LocalConnection.fixOptions(options), mapper, true);
    }

    public LocalConnection(String protocol, ConnectionOptions options) {
        this(protocol, options, new DefaultAddressPortMapper());
    }

    private static ConnectionOptions fixOptions(ConnectionOptions options) {
        options = new ConnectionOptions(options);
        options.set("os", (Object)OperatingSystemFamily.getLocalHostOperatingSystemFamily());
        if (options.getOptional("tmp") == null) {
            options.set("tmp", System.getProperty("java.io.tmpdir"));
        }
        return options;
    }

    @Override
    public OverthereConnection connect() {
        return this;
    }

    @Override
    public void doClose() {
    }

    @Override
    public OverthereFile getFile(String path) throws RuntimeIOException {
        return new LocalFile(this, new File(path));
    }

    @Override
    public OverthereFile getFile(OverthereFile parent, String child) throws RuntimeIOException {
        if (!(parent instanceof LocalFile)) {
            throw new IllegalStateException("parent is not a LocalOverthereFile");
        }
        File childFile = new File(((LocalFile)parent).getFile(), child);
        return new LocalFile(this, childFile);
    }

    @Override
    protected OverthereFile getFileForTempFile(OverthereFile parent, String name) {
        return this.getFile(parent, name);
    }

    @Override
    public OverthereProcess startProcess(CmdLine commandLine) {
        logger.info("Executing command {} on {}", (Object)commandLine, (Object)this);
        try {
            ProcessBuilder pb = new ProcessBuilder(commandLine.toCommandArray(this.os, false));
            if (this.workingDirectory != null) {
                pb.directory(((LocalFile)this.workingDirectory).getFile());
            }
            final Process p = pb.start();
            return new OverthereProcess(){

                @Override
                public OutputStream getStdin() {
                    return p.getOutputStream();
                }

                @Override
                public InputStream getStdout() {
                    return p.getInputStream();
                }

                @Override
                public InputStream getStderr() {
                    return p.getErrorStream();
                }

                @Override
                public int waitFor() throws InterruptedException {
                    return p.waitFor();
                }

                @Override
                public void destroy() {
                    p.destroy();
                }
            };
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Cannot start process for " + commandLine, exc);
        }
    }

    @Override
    public String toString() {
        return "local:";
    }

    public static OverthereConnection getLocalConnection() {
        return Overthere.getConnection(LOCAL_PROTOCOL, new ConnectionOptions());
    }
}

