/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.ConfigurationItemData;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.WorkDir;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class InMemoryRepositoryService
implements RepositoryService {
    private Map<String, ConfigurationItem> store = Maps.newHashMap();

    @Override
    public boolean exists(String id) {
        return this.store.containsKey(id);
    }

    @Override
    public <T extends ConfigurationItem> T read(String id) {
        return (T)this.store.get(id);
    }

    @Override
    public <T extends ConfigurationItem> T read(String id, WorkDir workDir) {
        return this.read(id);
    }

    @Override
    public <T extends ConfigurationItem> void create(T ... entities) {
        this.checkThatEntitiesDoNotExist((ConfigurationItem[])entities);
        this.storeEntities((ConfigurationItem[])entities);
    }

    private void checkThatEntitiesDoNotExist(ConfigurationItem[] entities) {
        for (ConfigurationItem entity : entities) {
            if (!this.store.containsKey(entity.getId())) continue;
            throw new IllegalStateException("Entity " + entity.getId() + " already exists and cannot be created twice.");
        }
    }

    private void storeEntities(ConfigurationItem[] entities) {
        for (ConfigurationItem entity : entities) {
            this.store.put(entity.getId(), entity);
        }
    }

    @Override
    public <T extends ConfigurationItem> void update(T ... entities) {
        for (T entity : entities) {
            if (this.store.containsKey(entity.getId())) continue;
            throw new IllegalStateException("Cannot update nonexisting");
        }
        for (T entity : entities) {
            this.store.put(entity.getId(), (ConfigurationItem)entity);
        }
    }

    @Override
    public <T extends ConfigurationItem> void move(T entity, String newId) {
        this.store.remove(entity.getId());
        entity.setId(newId);
        this.store.put(newId, entity);
    }

    @Override
    public void rename(String id, String newName) {
        ConfigurationItem remove = this.store.remove(id);
        remove.setId(id.substring(0, id.lastIndexOf(47) + 1) + newName);
        this.store.put(remove.getId(), remove);
    }

    @Override
    public void delete(String ... ids) {
        for (String id : ids) {
            this.store.remove(id);
        }
    }

    @Override
    public void execute(ChangeSet batchUpdate) {
        if (!batchUpdate.getCreateCis().isEmpty()) {
            this.create(batchUpdate.getCreateCis().toArray(new ConfigurationItem[batchUpdate.getCreateCis().size()]));
        }
        if (!batchUpdate.getUpdateCis().isEmpty()) {
            this.update(batchUpdate.getUpdateCis().toArray(new ConfigurationItem[batchUpdate.getUpdateCis().size()]));
        }
        if (!batchUpdate.getDeleteCiIds().isEmpty()) {
            this.delete(batchUpdate.getDeleteCiIds().toArray(new String[batchUpdate.getDeleteCiIds().size()]));
        }
    }

    @Override
    public List<ConfigurationItemData> list(SearchParameters criteria) {
        ArrayList ids = Lists.newArrayList();
        if (criteria.type != null) {
            for (ConfigurationItem configurationItem : this.store.values()) {
                if (!configurationItem.getType().equals((Object)criteria.type)) continue;
                ids.add(new ConfigurationItemData(configurationItem.getId(), configurationItem.getType()));
            }
            return ids;
        }
        throw new UnsupportedOperationException("Ask Jeroen");
    }

    @Override
    public <T extends ConfigurationItem> List<T> listEntities(SearchParameters parameters) {
        throw new UnsupportedOperationException("Ask Robert and Vincent");
    }

    @Override
    public void checkReferentialIntegrity(ChangeSet batchUpdate) throws ItemInUseException {
    }

    @Override
    public <T extends ConfigurationItem> List<T> getVersionHistory(String id) {
        throw new UnsupportedOperationException("Not implemented for " + this.getClass());
    }
}

