/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.security.authentication;

import com.google.common.collect.MapMaker;
import com.xebialabs.deployit.conversion.Base64Coder;
import com.xebialabs.deployit.security.SecurityUtils;
import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;

public class RememberMe {
    private static final ConcurrentMap<String, Authentication> AUTH_CACHE = new MapMaker().expireAfterAccess(10L, TimeUnit.MINUTES).makeMap();
    private static final Logger logger = LoggerFactory.getLogger(RememberMe.class);

    public static void remember(Authentication auth) {
        String key = RememberMe.createKey(auth);
        logger.debug("Remembering authentication token for [{}]", (Object)auth.getName());
        AUTH_CACHE.put(key, auth);
    }

    public static void forget(Authentication auth) {
        String key = RememberMe.createKey(auth);
        if (AUTH_CACHE.containsKey(key)) {
            AUTH_CACHE.remove(key);
        } else {
            logger.info("Couldn't forget authentication for [{}] because it was not remembered.", (Object)auth.getName());
        }
    }

    public static Authentication getRemembered(String username, String password) {
        String key = RememberMe.encodeUserPassword(username, password);
        if (AUTH_CACHE.containsKey(key)) {
            return (Authentication)AUTH_CACHE.get(key);
        }
        logger.debug("Token for [{}] not yet remembered.", (Object)username);
        return null;
    }

    public static void forgetMe() {
        RememberMe.forget(SecurityUtils.getAuthentication());
    }

    private static String createKey(Authentication auth) {
        if (auth instanceof UsernamePasswordAuthenticationToken) {
            UsernamePasswordAuthenticationToken token = (UsernamePasswordAuthenticationToken)auth;
            String user = token.getName();
            String password = token.getCredentials().toString();
            return RememberMe.encodeUserPassword(user, password);
        }
        throw new IllegalArgumentException("The authentication should always be a UsernamePasswordAuthenticationToken");
    }

    private static String encodeUserPassword(String user, String password) {
        return new String(new Base64Coder().encode((user + ":" + password).getBytes()), Charset.defaultCharset());
    }
}

