/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.importer.reader;

import com.google.common.io.Closeables;
import com.xebialabs.deployit.exception.RuntimeIOException;
import com.xebialabs.deployit.service.importer.ImporterException;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Manifest;

public class ManifestReader {
    public static final String PACKAGE_FORMAT_VERSION_ATTRIBUTE_NAME = "Deployit-Package-Format-Version";
    public static final String PACKAGE_FORMAT_VERSION_NUMBER = "1.3";
    public static final String APPLICATION_ATTRIBUTE_NAME = "CI-Application";
    public static final String VERSION_ATTRIBUTE_NAME = "CI-Version";

    public static Manifest readManifest(TFile manifestFile) {
        Manifest manifest;
        TFileInputStream in = null;
        try {
            in = new TFileInputStream((File)manifestFile);
            manifest = new Manifest((InputStream)in);
        }
        catch (IOException exception) {
            try {
                throw new RuntimeIOException("Cannot read manifest file " + manifestFile, exception);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(in);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)in);
        return manifest;
    }

    public static String getApplicationName(Manifest manifest) {
        return ManifestReader.getMainEntryAttribute(manifest, APPLICATION_ATTRIBUTE_NAME);
    }

    public static String getApplicationVersion(Manifest manifest) {
        return ManifestReader.getMainEntryAttribute(manifest, VERSION_ATTRIBUTE_NAME);
    }

    private static String getMainEntryAttribute(Manifest manifest, String attributeName) {
        String attributeValue = manifest.getMainAttributes().getValue(attributeName);
        if (attributeValue == null || attributeValue.trim().isEmpty()) {
            throw new ImporterException("Deployment package does not declare the " + attributeName + " main attribute", new Object[0]);
        }
        return attributeValue;
    }

    public static void verifyPackageFormatVersion(Manifest manifest) {
        String packageFormatVersion = ManifestReader.getMainEntryAttribute(manifest, PACKAGE_FORMAT_VERSION_ATTRIBUTE_NAME);
        if (!PACKAGE_FORMAT_VERSION_NUMBER.equals(packageFormatVersion)) {
            throw new ImporterException("Deployment package does not have the right Deployit-Package-Format-Version header value (actual: " + packageFormatVersion + " expected: " + PACKAGE_FORMAT_VERSION_NUMBER + ")", new Object[0]);
        }
    }
}

