/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.task;

import com.xebialabs.deployit.task.DeploymentTask;
import com.xebialabs.deployit.task.Task;
import com.xebialabs.deployit.task.TaskStepInfo;
import java.util.Calendar;
import java.util.List;

public class DeploymentTaskInfo {
    private String id;
    private String owner;
    private Calendar startDate;
    private Calendar completionDate;
    private List<TaskStepInfo> steps;
    private Task.State state;
    private DeploymentTask.DeploymentType deploymentType;
    private String applicationName;
    private String applicationVersion;
    private String environment;
    private int currentStepNr;
    private int failureCount;

    public TaskStepInfo getStep(int stepNr) {
        if (stepNr < 1 || stepNr > this.steps.size()) {
            throw new IllegalArgumentException(stepNr + " is not a valid step number");
        }
        return this.steps.get(stepNr - 1);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public Calendar getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Calendar startDate) {
        this.startDate = startDate;
    }

    public Calendar getCompletionDate() {
        return this.completionDate;
    }

    public long getDurationInMillis() {
        return this.completionDate.getTimeInMillis() - this.startDate.getTimeInMillis();
    }

    public List<TaskStepInfo> getSteps() {
        return this.steps;
    }

    public void setCompletionDate(Calendar completionDate) {
        this.completionDate = completionDate;
    }

    public void setSteps(List<TaskStepInfo> steps) {
        this.steps = steps;
    }

    public Task.State getState() {
        return this.state;
    }

    public void setState(Task.State state) {
        this.state = state;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public void setApplicationVersion(String applicationVersion) {
        this.applicationVersion = applicationVersion;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public int getFailureCount() {
        return this.failureCount;
    }

    public void setFailureCount(int failureCount) {
        this.failureCount = failureCount;
    }

    public int getCurrentStepNr() {
        return this.currentStepNr;
    }

    public void setCurrentStepNr(int currentStepNr) {
        this.currentStepNr = currentStepNr;
    }

    public DeploymentTask.DeploymentType getDeploymentType() {
        return this.deploymentType;
    }

    public void setDeploymentType(DeploymentTask.DeploymentType deploymentType) {
        this.deploymentType = deploymentType;
    }

    public String toString() {
        return "DeploymentTaskInfo{id='" + this.id + '\'' + ", owner='" + this.owner + '\'' + ", startDate=" + this.startDate + ", completionDate=" + this.completionDate + ", steps=" + this.steps + ", state=" + (Object)((Object)this.state) + ", deploymentType=" + (Object)((Object)this.deploymentType) + ", applicationName='" + this.applicationName + '\'' + ", applicationVersion='" + this.applicationVersion + '\'' + ", environment='" + this.environment + '\'' + ", currentStepNr=" + this.currentStepNr + '}';
    }
}

