/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.core.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.rest.api.reports.ReportFilterType;
import com.xebialabs.deployit.core.rest.api.reports.TaskStateData;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.DeploymentTaskInfo;
import com.xebialabs.deployit.task.Task;
import com.xebialabs.deployit.task.TaskArchive;
import com.xebialabs.deployit.task.jcrarchive.JcrTaskArchive;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeploymentsStateBreakdownReport {
    private TaskArchive taskArchive;

    public DeploymentsStateBreakdownReport(TaskArchive taskArchive) {
        this.taskArchive = taskArchive;
    }

    public Report report(List<ConfigurationItemId> filterCriteria, Date startDate, Date endDate, final ReportFilterType filterType) {
        final HashMap tasksMap = Maps.newHashMap();
        ArchivedTaskSearchParameters searchTasks = new ArchivedTaskSearchParameters();
        searchTasks.createdBetween(startDate.getCalendar(), endDate.getCalendar());
        for (ConfigurationItemId appOrEnvName : filterCriteria) {
            switch (filterType) {
                case APPLICATION: {
                    searchTasks.forApplication(appOrEnvName.getId());
                    break;
                }
                case ENVIRONMENT: {
                    searchTasks.toEnvironment(appOrEnvName.getId());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Report filter type, " + (Object)((Object)filterType) + " is not supported");
                }
            }
            this.taskArchive.searchTasksWithoutLoadingSteps(searchTasks, new JcrTaskArchive.TaskCallback(){

                public void doWithTask(DeploymentTaskInfo task) {
                    DeploymentsStateBreakdownReport.this.createFilteredTasksMap(tasksMap, task, filterType);
                }
            });
        }
        for (ConfigurationItemId entityId : filterCriteria) {
            if (tasksMap.containsKey(entityId.getId())) continue;
            tasksMap.put(entityId.getId(), new TaskStateData());
        }
        return this.generateReportDataFromTaskMap(tasksMap);
    }

    private Report generateReportDataFromTaskMap(Map<String, TaskStateData> tasksMap) {
        Report report = new Report();
        for (Map.Entry<String, TaskStateData> entry : tasksMap.entrySet()) {
            Report.ReportLine reportLine = report.addLine();
            reportLine.addValue("entityName", (Object)entry.getKey());
            reportLine.addValue("noOfSuccessfulDeployments", (Object)entry.getValue().getNoOfSuccessfulDeployments().toString());
        }
        return report;
    }

    private void createFilteredTasksMap(Map<String, TaskStateData> tasksMap, DeploymentTaskInfo task, ReportFilterType filterType) {
        String entityId = this.getEntityIdFromDeploymentTask(task, filterType);
        if (task.getState().equals((Object)Task.State.DONE)) {
            if (!tasksMap.containsKey(entityId)) {
                TaskStateData taskStateData = new TaskStateData();
                taskStateData.getNoOfSuccessfulDeployments().incrementAndGet();
                tasksMap.put(entityId, taskStateData);
            } else {
                tasksMap.get(entityId).getNoOfSuccessfulDeployments().incrementAndGet();
            }
        }
    }

    private String getEntityIdFromDeploymentTask(DeploymentTaskInfo inputTask, ReportFilterType filterType) {
        String entityId = "";
        switch (filterType) {
            case APPLICATION: {
                entityId = inputTask.getApplicationName();
                break;
            }
            case ENVIRONMENT: {
                entityId = inputTask.getEnvironment();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Report filter type, " + (Object)((Object)filterType) + " is not supported");
            }
        }
        return entityId;
    }
}

