/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports.widgets;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.rest.api.reports.widgets.DashboardWidgetBase;
import com.xebialabs.deployit.core.rest.api.reports.widgets.Widget;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.DeploymentTaskInfo;
import com.xebialabs.deployit.task.TaskArchive;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

public class DeploymentsDurationFrequencyWidget
extends DashboardWidgetBase {
    private static final String INTERVAL = "interval";
    private static final String DEPLOYMENT_PERCENT = "deploymentPercent";
    private static final String NUM_OF_DEPLOYMENT = "numOfDeployment";
    private final DecimalFormat format = new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(Locale.ENGLISH));

    public DeploymentsDurationFrequencyWidget(TaskArchive taskArchive) {
        this.taskArchive = taskArchive;
    }

    public static final Widget getInstance(TaskArchive taskArchive) {
        return new DeploymentsDurationFrequencyWidget(taskArchive);
    }

    @Override
    public Report getReport(Date begin, Date end) {
        ArchivedTaskSearchParameters sp = new ArchivedTaskSearchParameters().createdBetween(begin.getCalendar(), end.getCalendar()).thatCompleted();
        Collection foundTasks = this.taskArchive.searchTasksWithoutLoadingSteps(sp);
        if (foundTasks.size() == 0) {
            return new Report();
        }
        return this.generateReport(foundTasks);
    }

    private Report generateReport(Collection<DeploymentTaskInfo> foundTasks) {
        long mean = this.mean(foundTasks);
        long standardDeviation = this.standardDeviation(mean, foundTasks);
        List<Long> clusterLimits = this.clusterLimits(mean, standardDeviation);
        return this.createDetails(foundTasks, clusterLimits);
    }

    private long mean(Collection<DeploymentTaskInfo> tasks) {
        long total = 0L;
        for (DeploymentTaskInfo taskState : tasks) {
            total += taskState.getDurationInMillis();
        }
        return total / (long)tasks.size();
    }

    private long standardDeviation(long mean, Collection<DeploymentTaskInfo> tasks) {
        if (tasks.size() > 1) {
            long total = 0L;
            for (DeploymentTaskInfo taskState : tasks) {
                long distance = taskState.getDurationInMillis() - mean;
                total += distance * distance;
            }
            return (long)Math.sqrt(total / (long)(tasks.size() - 1));
        }
        return 0L;
    }

    private List<Long> clusterLimits(long mean, long standardDeviation) {
        ArrayList clusterLimits = Lists.newArrayList();
        if (standardDeviation > 0L && mean - standardDeviation - standardDeviation > 0L) {
            clusterLimits.add(mean - standardDeviation - standardDeviation);
        }
        if (standardDeviation > 0L && mean - standardDeviation > 0L) {
            clusterLimits.add(mean - standardDeviation);
        }
        clusterLimits.add(mean);
        if (standardDeviation > 0L) {
            clusterLimits.add(mean + standardDeviation);
            clusterLimits.add(mean + standardDeviation + standardDeviation);
        }
        return clusterLimits;
    }

    private Report createDetails(Collection<DeploymentTaskInfo> tasks, List<Long> clusterLimits) {
        Report report = new Report();
        int[] clusters = this.cluster(tasks, clusterLimits);
        int totalDeployments = tasks.size();
        if (totalDeployments > 1) {
            Report.ReportLine firstLine = report.addLine();
            firstLine.addValue(INTERVAL, (Object)("<" + this.formatToMinsAndSecs(clusterLimits.get(0))));
            firstLine.addValue(DEPLOYMENT_PERCENT, (Object)this.format.format(this.getPercentage(clusters[0], totalDeployments)));
            firstLine.addValue(NUM_OF_DEPLOYMENT, (Object)this.format.format(clusters[0]));
        }
        for (int i = 1; i < clusterLimits.size(); ++i) {
            Report.ReportLine line = report.addLine();
            line.addValue(INTERVAL, (Object)(this.formatToMinsAndSecs(clusterLimits.get(i - 1)) + " - " + this.formatToMinsAndSecs(clusterLimits.get(i))));
            line.addValue(DEPLOYMENT_PERCENT, (Object)this.format.format(this.getPercentage(clusters[i], totalDeployments)));
            line.addValue(NUM_OF_DEPLOYMENT, (Object)this.format.format(clusters[i]));
        }
        Report.ReportLine lastLine = report.addLine();
        lastLine.addValue(INTERVAL, (Object)(">" + this.formatToMinsAndSecs(clusterLimits.get(clusterLimits.size() - 1))));
        lastLine.addValue(DEPLOYMENT_PERCENT, (Object)this.format.format(this.getPercentage(clusters[clusters.length - 1], totalDeployments)));
        lastLine.addValue(NUM_OF_DEPLOYMENT, (Object)this.format.format(clusters[clusters.length - 1]));
        return report;
    }

    private int[] cluster(Collection<DeploymentTaskInfo> tasks, List<Long> clusterLimits) {
        int[] cluster = new int[clusterLimits.size() + 1];
        for (DeploymentTaskInfo taskState : tasks) {
            boolean aboveMaxLimit = true;
            for (int i = 0; i < clusterLimits.size(); ++i) {
                Long limit = clusterLimits.get(i);
                if (taskState.getDurationInMillis() >= limit) continue;
                int n = i;
                cluster[n] = cluster[n] + 1;
                aboveMaxLimit = false;
                break;
            }
            if (!aboveMaxLimit) continue;
            int n = clusterLimits.size();
            cluster[n] = cluster[n] + 1;
        }
        return cluster;
    }
}

