/*
 * Decompiled with CFR 0.152.
 */
package nl.javadude.scannit;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import nl.javadude.scannit.Configuration;
import nl.javadude.scannit.Worker;
import nl.javadude.scannit.registry.Registry;
import nl.javadude.scannit.registry.RegistryHelper;

public class Scannit {
    private static final AtomicReference<Scannit> REF = new AtomicReference();
    final Registry registry = new Registry();
    private RegistryHelper registryHelper;

    public Scannit(Configuration configuration) {
        configuration.wireScanners();
        new Worker(configuration, this.registry).scan();
        this.registryHelper = new RegistryHelper(this.registry);
    }

    public static synchronized Scannit boot(Configuration configuration) {
        REF.set(new Scannit(configuration));
        return REF.get();
    }

    public static synchronized void setInstance(Scannit scannit) {
        REF.set(scannit);
    }

    public static synchronized Scannit getInstance() {
        if (REF.get() != null) {
            return REF.get();
        }
        throw new IllegalStateException("Scannit not set via setInstance(Scannit) or boot(Configuration)");
    }

    public Set<Class<?>> getTypesAnnotatedWith(Class<? extends Annotation> annotation) {
        return this.registryHelper.getTypesAnnotatedWith(annotation, true);
    }

    public Set<Method> getMethodsAnnotatedWith(Class<? extends Annotation> annotation) {
        return this.registryHelper.getMethodsAnnotatedWith(annotation);
    }

    public Set<Field> getFieldsAnnotatedWith(Class<? extends Annotation> annotation) {
        return this.registryHelper.getFieldsAnnotatedWith(annotation);
    }

    public <T> Set<Class<? extends T>> getSubTypesOf(Class<T> clazz) {
        return this.registryHelper.getSubTypesOf(clazz);
    }
}

