/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.remote;

import com.xebialabs.deployit.booter.remote.BooterConfig;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientHolder {
    private static final AtomicReference<HttpClientHolder> REF = new AtomicReference();
    String username;
    String password;
    DefaultHttpClient httpClient;
    HttpHost host;
    BasicHttpContext localcontext;
    private static final Logger logger = LoggerFactory.getLogger(HttpClientHolder.class);

    private HttpClientHolder(BooterConfig config) {
        ThreadSafeClientConnManager connManager = new ThreadSafeClientConnManager();
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)connManager);
        if (config.isSecure()) {
            this.setupSecureComms();
        }
        this.host = new HttpHost(config.getHost(), config.getPort(), String.format("http%s", config.isSecure() ? "s" : ""));
        this.localcontext = new BasicHttpContext();
        this.username = config.getUsername();
        this.password = config.getPassword();
        this.addCredentials();
        this.enablePreemptiveAuthentication();
        this.httpClient.getParams().setIntParameter("http.connection.timeout", 10000);
    }

    private void setupSecureComms() {
        try {
            SSLSocketFactory sslSocketFactory = new SSLSocketFactory((TrustStrategy)new TrustSelfSignedStrategy());
            Scheme scheme = new Scheme("https", 443, (SchemeSocketFactory)sslSocketFactory);
            this.httpClient.getConnectionManager().getSchemeRegistry().register(scheme);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot setup secure communications with Deployit", e);
        }
    }

    public static HttpClientHolder getInstance() {
        if (REF.get() == null) {
            throw new IllegalStateException("Should be inited!");
        }
        return REF.get();
    }

    static void init(BooterConfig config) {
        HttpClientHolder h = new HttpClientHolder(config);
        REF.compareAndSet(null, h);
    }

    static void shutdown() {
        REF.get().getHttpClient().getConnectionManager().shutdown();
        REF.set(null);
    }

    private void addCredentials() {
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.username, this.password);
        this.httpClient.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)credentials);
    }

    private void enablePreemptiveAuthentication() {
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(this.host, (AuthScheme)basicAuth);
        this.localcontext.setAttribute("http.auth.auth-cache", (Object)authCache);
    }

    public void logout() {
        this.username = null;
        this.password = null;
        this.httpClient.getCookieStore().clear();
        this.httpClient.getCredentialsProvider().clear();
    }

    public String getUserName() {
        return this.username;
    }

    public void loginAs(String username, String password) {
        if (this.httpClient.getCredentialsProvider().getCredentials(AuthScope.ANY) != null) {
            logger.error("You're still logged in as another user, please logout first.");
            return;
        }
        this.username = username;
        this.password = password;
        this.addCredentials();
        this.httpClient.getCookieStore().clear();
    }

    public static HttpClient httpClient() {
        return HttpClientHolder.getInstance().getHttpClient();
    }

    public static HttpContext httpContext() {
        return HttpClientHolder.getInstance().getHttpContext();
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public HttpContext getHttpContext() {
        return this.localcontext;
    }

    public HttpHost getHost() {
        return this.host;
    }
}

