/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.cli.api;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.cli.CliObject;
import com.xebialabs.deployit.cli.api.DocumentedObject;
import com.xebialabs.deployit.cli.api.ProxiesInstance;
import com.xebialabs.deployit.cli.help.ClassHelp;
import com.xebialabs.deployit.cli.help.MethodHelp;
import com.xebialabs.deployit.cli.help.ParameterHelp;
import com.xebialabs.deployit.engine.api.dto.ArtifactAndData;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import java.util.Collection;
import java.util.Map;
import java.util.TreeSet;

@CliObject(name="factory")
@ClassHelp(description="Helper that can construct Configuration Items (CI) and Artifacts")
public class ObjectFactory
extends DocumentedObject {
    public ObjectFactory(ProxiesInstance proxiesInstance) {
    }

    public ObjectFactory() {
    }

    @MethodHelp(description="Construct a CI of a specified type", parameters={@ParameterHelp(name="id", description="The id of the CI"), @ParameterHelp(name="ciType", description="The type of the CI")})
    public ConfigurationItem configurationItem(String id, String ciType) {
        return ObjectFactory.ci(id, ciType, Maps.newHashMap());
    }

    @MethodHelp(description="Construct a CI of a specified type with specified values", parameters={@ParameterHelp(name="id", description="The id of the CI"), @ParameterHelp(name="ciType", description="The type of the CI"), @ParameterHelp(name="values", description="The values of the CI in a map.")})
    public ConfigurationItem configurationItem(String id, String ciType, Map<String, Object> values) {
        return ObjectFactory.ci(id, ciType, values);
    }

    private static ConfigurationItem ci(String id, String ciType, Map<String, Object> values) {
        Preconditions.checkArgument((boolean)ObjectFactory.isValidType(ciType), (String)"Unknown CI type %s", (Object[])new Object[]{ciType});
        Type type = Type.valueOf((String)ciType);
        ConfigurationItem configurationItem = type.getDescriptor().newInstance();
        configurationItem.setId(id);
        for (String s : values.keySet()) {
            PropertyDescriptor propertyDescriptor = type.getDescriptor().getPropertyDescriptor(s);
            if (propertyDescriptor == null) continue;
            propertyDescriptor.set(configurationItem, values.get(s));
        }
        return configurationItem;
    }

    @MethodHelp(description="Construct an artifact of a specific type with associated data", parameters={@ParameterHelp(name="id", description="The id of the artifact"), @ParameterHelp(name="ciType", description="The type of the artifact"), @ParameterHelp(name="values", description="The values for the artifact in a map."), @ParameterHelp(name="data", description="The data of the artifact that is to be uploaded")}, returns="An Artifact with data that can be stored in Deployit.")
    public ArtifactAndData artifact(String id, String ciType, Map<String, Object> values, byte[] data) {
        ConfigurationItem ci = ObjectFactory.ci(id, ciType, values);
        Preconditions.checkArgument((boolean)(ci instanceof Artifact), (String)"The type should be an Artifact (was: [%s], type: [%s])", (Object[])new Object[]{ci.getClass(), ciType});
        return new ArtifactAndData((Artifact)ci, data);
    }

    @MethodHelp(description="Prints all registered configuration item types.")
    public void types() {
        TreeSet typeSet = Sets.newTreeSet((Iterable)Collections2.transform((Collection)DescriptorRegistry.getDescriptors(), (Function)new Function<Descriptor, String>(){

            public String apply(Descriptor input) {
                return input.getType().toString();
            }
        }));
        System.out.printf("The registered configuration item types are:\n%s\n\n", typeSet);
    }

    public static Type toType(String ciType) {
        if (ciType == null) {
            return null;
        }
        return Type.valueOf((String)ciType);
    }

    private static boolean isValidType(String ciType) {
        return DescriptorRegistry.exists((Type)Type.valueOf((String)ciType));
    }
}

