/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.deployment.planner.Plan;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.spi.execution.ExecutionStateListener;
import com.xebialabs.deployit.engine.spi.execution.StepExecutionStateEvent;
import com.xebialabs.deployit.engine.spi.execution.TaskExecutionStateEvent;
import com.xebialabs.deployit.engine.spi.execution.Transitions;
import com.xebialabs.deployit.engine.tasker.TaskStep;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import com.xebialabs.deployit.plugin.api.udm.DeployedApplication;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.ConfigurationItemCloner;
import com.xebialabs.deployit.repository.RepositoryServiceHolder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartialCommitTrigger
implements ExecutionStateListener {
    private DeltaSpecification specification;
    private DeployedApplication inprogressDeployedApplication;
    private List<Plan.Checkpoint> checkpoints;
    private List<Plan.Checkpoint> checkpointed = Lists.newArrayList();
    private static final Logger logger = LoggerFactory.getLogger(PartialCommitTrigger.class);

    public PartialCommitTrigger(DeltaSpecification specification, List<Plan.Checkpoint> checkpoints) {
        this.specification = specification;
        if (specification.getOperation() == Operation.CREATE) {
            this.inprogressDeployedApplication = ConfigurationItemCloner.cloneShallow(specification.getDeployedApplication());
            this.inprogressDeployedApplication.getDeployeds().clear();
        } else {
            this.inprogressDeployedApplication = ConfigurationItemCloner.cloneShallow(specification.getPreviousDeployedApplication());
        }
        this.checkpoints = checkpoints;
    }

    public void stepStateChanged(StepExecutionStateEvent event) {
        final TaskStep step = (TaskStep)event.step();
        if (!step.getState().isFinal()) {
            return;
        }
        Iterable matchingCheckpoints = Iterables.filter(this.checkpoints, (Predicate)new Predicate<Plan.Checkpoint>(){

            public boolean apply(Plan.Checkpoint input) {
                return input.getStep().equals(step.getImplementation());
            }
        });
        for (Plan.Checkpoint checkpoint : matchingCheckpoints) {
            this.makeCheckpoint(checkpoint);
        }
    }

    private void makeCheckpoint(final Plan.Checkpoint checkpoint) {
        logger.debug("Checkpointing...");
        Optional optionalCheckpoint = Iterables.tryFind(this.checkpointed, (Predicate)new Predicate<Plan.Checkpoint>(){

            public boolean apply(Plan.Checkpoint input) {
                return input.getDelta().equals(checkpoint.getDelta());
            }
        });
        boolean added = false;
        if (optionalCheckpoint.isPresent()) {
            Plan.Checkpoint foundCheckpoint = (Plan.Checkpoint)optionalCheckpoint.get();
            this.checkpointed.remove(foundCheckpoint);
            if (foundCheckpoint.getDelta().getOperation() == Operation.MODIFY) {
                added = this.doModifyCheckpoint(foundCheckpoint, checkpoint);
            }
        }
        if (!added) {
            this.checkpointed.add(checkpoint);
        }
    }

    private boolean doModifyCheckpoint(Plan.Checkpoint foundCheckpoint, Plan.Checkpoint checkpoint) {
        if (foundCheckpoint.getOperation() == Operation.DESTROY && checkpoint.getOperation() == Operation.CREATE) {
            this.checkpointed.add(new Plan.Checkpoint(checkpoint.getDelta(), checkpoint.getStep()));
            return true;
        }
        return false;
    }

    public void taskStateChanged(TaskExecutionStateEvent event) {
        if (Transitions.checkTransition((TaskExecutionStateEvent)event, (TaskExecutionState)TaskExecutionState.STOPPED, (TaskExecutionState)TaskExecutionState.CANCELLED)) {
            this.doPartialCommit();
        }
    }

    private void doPartialCommit() {
        if (this.specification.getOperation() == Operation.CREATE && this.checkpointed.isEmpty()) {
            return;
        }
        ChangeSet cs = new ChangeSet();
        for (Plan.Checkpoint checkpoint : this.checkpointed) {
            Deployed deployed = checkpoint.getDelta().getDeployed();
            Deployed previousDeployed = checkpoint.getDelta().getPrevious();
            switch (checkpoint.getOperation()) {
                case CREATE: {
                    this.inprogressDeployedApplication.addDeployed(deployed);
                    cs.createOrUpdate(deployed);
                    break;
                }
                case MODIFY: 
                case NOOP: {
                    this.inprogressDeployedApplication.getDeployeds().remove(previousDeployed);
                    this.inprogressDeployedApplication.addDeployed(deployed);
                    cs.createOrUpdate(deployed);
                    break;
                }
                case DESTROY: {
                    this.inprogressDeployedApplication.getDeployeds().remove(previousDeployed);
                    cs.delete((ConfigurationItem)previousDeployed);
                }
            }
        }
        if (this.inprogressDeployedApplication.getDeployeds().isEmpty()) {
            cs.delete((ConfigurationItem)this.inprogressDeployedApplication);
        } else {
            cs.createOrUpdate(this.inprogressDeployedApplication);
        }
        RepositoryServiceHolder.getRepositoryService().execute(cs);
    }

    DeltaSpecification getSpecification() {
        return this.specification;
    }

    DeployedApplication getInprogressDeployedApplication() {
        return this.inprogressDeployedApplication;
    }
}

