/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.api.resteasy.Date;
import com.xebialabs.deployit.core.rest.api.reports.ReportUtils;
import com.xebialabs.deployit.core.rest.api.reports.TaskArchiveReport;
import com.xebialabs.deployit.jcr.grouping.Function;
import com.xebialabs.deployit.jcr.grouping.GroupBy;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.TaskType;
import com.xebialabs.deployit.task.archive.ArchivedTask;
import com.xebialabs.deployit.task.archive.JcrTaskArchive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.ReadableInstant;

public class DeploymentsForEnvironmentReport
extends TaskArchiveReport {
    private final Map<String, Map<String, String>> lastTask = new HashMap<String, Map<String, String>>();
    private final Map<String, Map<String, String>> beforeLastTask = new HashMap<String, Map<String, String>>();

    public DeploymentsForEnvironmentReport(JcrTaskArchive taskArchive) {
        super(taskArchive);
    }

    public Report report() {
        Report report = new Report();
        HashMap previous = new HashMap();
        ArchivedTaskSearchParameters params = this.getSearchParameters().orderBy("startDate");
        Collection searchResult = this.taskArchive.searchTasksWithoutLoadingSteps(params, new GroupBy((Collection)Lists.newArrayList((Object[])new String[]{"application"}), new Function[]{new Function<Map<String, String>>(){

            public Map<String, String> invoke(Object previousValue, ArchivedTask task) {
                if (previousValue == null) {
                    return this.getTaskInfo(task);
                }
                Map taskInfo = (Map)previousValue;
                String application = (String)taskInfo.get("application");
                Map prevTask = (Map)DeploymentsForEnvironmentReport.this.lastTask.get(application);
                if (task != null) {
                    DeploymentsForEnvironmentReport.this.beforeLastTask.put(application, prevTask);
                }
                DeploymentsForEnvironmentReport.this.lastTask.put(application, taskInfo);
                return this.getTaskInfo(task);
            }

            private Map<String, String> getTaskInfo(ArchivedTask task) {
                HashMap value = Maps.newHashMap();
                value.put("taskId", task.getId());
                value.put("application", task.getMetadata().get("application"));
                value.put("deploymentType", task.getMetadata().get("taskType"));
                value.put("user", task.getOwner());
                value.put("date", ReportUtils.FORMATTER.print((ReadableInstant)task.getCompletionDate()));
                value.put("version", task.getMetadata().get("version"));
                return value;
            }

            public String getName() {
                return "taskInfo";
            }
        }}));
        ArrayList results = Lists.newArrayList((Iterable)searchResult);
        Collections.sort(results, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> lhs, Map<String, Object> rhs) {
                Map lhsTaskInfo = (Map)lhs.get("taskInfo");
                Map rhsTaskInfo = (Map)rhs.get("taskInfo");
                Date lhsCompletionDate = new Date((String)lhsTaskInfo.get("date"));
                Date rhsCompletionDate = new Date((String)rhsTaskInfo.get("date"));
                return lhsCompletionDate.compareTo(rhsCompletionDate);
            }
        });
        for (Map task : results) {
            Map<String, String> taskInfo = (Map<String, String>)task.get("taskInfo");
            if (!this.notUndeployTask(taskInfo) || !this.notRollbackOnInitial(taskInfo)) continue;
            if (this.rollbankOnUpgrade(taskInfo)) {
                taskInfo = this.beforeLastTask.get(task.get("application"));
            }
            Report.ReportLine line = report.addLine();
            line.addValue("application", task.get("application"));
            line.addValue("taskId", (Object)taskInfo.get("taskId"));
            line.addValue("version", (Object)taskInfo.get("version"));
            line.addValue("user", (Object)taskInfo.get("user"));
            line.addValue("date", (Object)taskInfo.get("date"));
        }
        return report;
    }

    private boolean rollbankOnUpgrade(Map<String, String> taskInfo) {
        Map<String, String> application = this.lastTask.get(taskInfo.get("application"));
        return TaskType.valueOf((String)taskInfo.get("deploymentType")).equals((Object)TaskType.ROLLBACK) && application != null && TaskType.valueOf((String)application.get("deploymentType")).equals((Object)TaskType.UPGRADE);
    }

    private boolean notRollbackOnInitial(Map<String, String> taskInfo) {
        Map<String, String> application = this.lastTask.get(taskInfo.get("application"));
        return !TaskType.valueOf((String)taskInfo.get("deploymentType")).equals((Object)TaskType.ROLLBACK) || application == null || !TaskType.valueOf((String)application.get("deploymentType")).equals((Object)TaskType.INITIAL);
    }

    private boolean notUndeployTask(Map<String, String> taskInfo) {
        return !TaskType.valueOf((String)taskInfo.get("deploymentType")).equals((Object)TaskType.UNDEPLOY);
    }
}

