/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.booter.local.DelegateRegistry;
import com.xebialabs.deployit.booter.local.SyntheticHelper;
import com.xebialabs.deployit.booter.local.Verifications;
import com.xebialabs.deployit.booter.local.utils.ReflectionUtils;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.MethodDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

class LocalMethodDescriptor
implements MethodDescriptor {
    private static final String CONTROL_TASK_DISPATCH_METHOD = "controlTaskDispatch";
    private static final Set<String> RESERVED_ATTRIBUTE_NAMES = Sets.newHashSet((Object[])new String[]{"name", "label", "description"});
    private String name;
    private String label;
    private Method method;
    private String description;
    private String delegate;
    private Map<String, String> attributes = Maps.newHashMap();
    private Descriptor descriptor;

    private LocalMethodDescriptor(Descriptor descriptor, String name) {
        this.descriptor = descriptor;
        this.name = name;
    }

    private LocalMethodDescriptor(Descriptor descriptor, Method method) {
        this.method = method;
        this.name = method.getName();
        this.descriptor = descriptor;
    }

    LocalMethodDescriptor(LocalMethodDescriptor copyOf, Descriptor newOwner) {
        this.method = copyOf.method;
        this.name = copyOf.name;
        this.description = copyOf.description;
        this.label = copyOf.label;
        this.attributes = copyOf.attributes;
        this.descriptor = newOwner;
    }

    static MethodDescriptor from(Descriptor descriptor, Method method) {
        LocalMethodDescriptor methodDescriptor = new LocalMethodDescriptor(descriptor, method);
        methodDescriptor.initMetadata();
        return methodDescriptor;
    }

    static MethodDescriptor from(Descriptor descriptor, Element element) {
        String name = SyntheticHelper.getRequiredStringAttribute(element, "name");
        LocalMethodDescriptor methodDescriptor = new LocalMethodDescriptor(descriptor, name);
        methodDescriptor.label = SyntheticHelper.getOptionalStringAttribute(element, "label", name);
        methodDescriptor.description = SyntheticHelper.getOptionalStringAttribute(element, "description", "No description.");
        methodDescriptor.delegate = SyntheticHelper.getOptionalStringAttribute(element, "delegate", null);
        methodDescriptor.attributes = LocalMethodDescriptor.readAttributes(element);
        return methodDescriptor;
    }

    private static Map<String, String> readAttributes(Element element) {
        HashMap map = Maps.newHashMap();
        NamedNodeMap xmlAttrs = element.getAttributes();
        for (int i = 0; i < xmlAttrs.getLength(); ++i) {
            Attr item = (Attr)xmlAttrs.item(i);
            if (RESERVED_ATTRIBUTE_NAMES.contains(item.getName())) continue;
            map.put(item.getName(), item.getValue());
        }
        return map;
    }

    private void initMetadata() {
        ControlTask annotation = this.method.getAnnotation(ControlTask.class);
        this.description = annotation.description();
        this.label = annotation.label().equals("") ? this.name : annotation.label();
    }

    void verify(Verifications verifications) {
        if (this.method != null) {
            verifications.verify(this.descriptor.getType(), this.method.getParameterTypes().length == 0, "ControlTask %s should not take any parameters", this.getFqn());
            verifications.verify(this.descriptor.getType(), List.class.isAssignableFrom(this.method.getReturnType()), "ControlTask %s should return a List<Step>", this.getFqn());
        } else if (this.delegate != null) {
            verifications.verify(this.descriptor.getType(), DelegateRegistry.exists(this.delegate), "No delegate called [%s] available for control task [%s]", this.delegate, this.getFqn());
        } else if (!this.attributes.isEmpty()) {
            Method controlTaskDispatch = this.getExtendedDispatcher();
            verifications.verify(this.descriptor.getType(), controlTaskDispatch != null, "ControlTask dispatcher %s for %s is not present.", CONTROL_TASK_DISPATCH_METHOD, this.getFqn());
            verifications.verify(this.descriptor.getType(), List.class.isAssignableFrom(controlTaskDispatch.getReturnType()), "ControlTask dispatcher %s for %s should return a List<Step>", CONTROL_TASK_DISPATCH_METHOD, this.getFqn());
        } else {
            Method controlTaskDispatch = this.getExtendedDispatcher();
            if (controlTaskDispatch == null) {
                controlTaskDispatch = this.getSimpleDispatcher();
            }
            verifications.verify(this.descriptor.getType(), controlTaskDispatch != null, "ControlTask dispatcher %s for %s is not present.", CONTROL_TASK_DISPATCH_METHOD, this.getFqn());
            verifications.verify(this.descriptor.getType(), List.class.isAssignableFrom(controlTaskDispatch.getReturnType()), "ControlTask dispatcher %s for %s should return a List<Step>", CONTROL_TASK_DISPATCH_METHOD, this.getFqn());
        }
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public <T> T invoke(ConfigurationItem item) {
        try {
            if (this.method != null) {
                return (T)this.method.invoke((Object)item, new Object[0]);
            }
            if (this.delegate != null) {
                return this.invokeDelegate(item);
            }
            return this.invokeDispatcher(item);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not invoke " + this.name + " on " + item, e);
        }
        catch (InvocationTargetException e) {
            throw ReflectionUtils.handleInvocationTargetException(e, "Could not invoke " + this.name + " on " + item);
        }
    }

    private <T> T invokeDelegate(ConfigurationItem item) throws InvocationTargetException, IllegalAccessException {
        Method method = DelegateRegistry.getDelegate(this.delegate);
        Object o = DelegateRegistry.instantiateDelegate(this.delegate);
        return (T)method.invoke(o, item, this.name, this.attributes);
    }

    private <T> T invokeDispatcher(ConfigurationItem item) throws InvocationTargetException, IllegalAccessException {
        Method dispatcher = this.getExtendedDispatcher();
        if (dispatcher == null) {
            dispatcher = this.getSimpleDispatcher();
            return (T)dispatcher.invoke((Object)item, this.name);
        }
        return (T)dispatcher.invoke((Object)item, this.name, this.attributes);
    }

    public String getFqn() {
        return String.format("%s.%s", this.descriptor.getType(), this.name);
    }

    private Method getSimpleDispatcher() {
        Class clazz = this.descriptor.getClazz();
        try {
            return clazz.getMethod(CONTROL_TASK_DISPATCH_METHOD, String.class);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private Method getExtendedDispatcher() {
        Class clazz = this.descriptor.getClazz();
        try {
            return clazz.getMethod(CONTROL_TASK_DISPATCH_METHOD, String.class, Map.class);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

