/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.cifs;

import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.cifs.PathMapper;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class PathEncoder {
    private static final Pattern UNC_PATH_PATTERN = Pattern.compile("\\\\\\\\[^\\\\]+\\\\([^\\\\]+(?:\\\\.*)?)");
    private static final char WINDOWS_SEPARATOR = '\\';
    private static final char SMB_URL_SEPARATOR = '/';
    private final String smbUrlPrefix;
    private final PathMapper pathMapper;

    PathEncoder(String username, String password, String address, int cifsPort, Map<String, String> pathMappings) {
        StringBuilder urlPrefix = new StringBuilder();
        urlPrefix.append("smb://");
        if (username != null) {
            urlPrefix.append(PathEncoder.urlEncode(username.replaceFirst(Pattern.quote("\\"), ";")));
            urlPrefix.append(":");
            urlPrefix.append(PathEncoder.urlEncode(password));
            urlPrefix.append("@");
        }
        urlPrefix.append(PathEncoder.urlEncode(address));
        if (cifsPort != 445) {
            urlPrefix.append(":");
            urlPrefix.append(cifsPort);
        }
        urlPrefix.append('/');
        this.smbUrlPrefix = urlPrefix.toString();
        this.pathMapper = new PathMapper(pathMappings);
    }

    private static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeIOException("Unable to construct SMB URL", e);
        }
    }

    String toSmbUrl(String hostPath) {
        if (hostPath.length() < 2) {
            throw new IllegalArgumentException(String.format("Host path '%s' is too short", hostPath));
        }
        if (hostPath.charAt(1) != ':') {
            throw new IllegalArgumentException(String.format("Host path '%s' does not have a colon (:) as its second character", hostPath));
        }
        if ((hostPath = hostPath.replace('/', '\\')).length() >= 3 && hostPath.charAt(2) != '\\') {
            throw new IllegalArgumentException(String.format("Host path '%s' does not have a backslash (\\) as its third character", hostPath));
        }
        StringBuilder smbUrl = new StringBuilder(this.smbUrlPrefix);
        smbUrl.append(this.pathMapper.toSharedPath(hostPath).replace('\\', '/'));
        return smbUrl.toString();
    }

    final String fromUncPath(String uncPath) {
        Matcher matcher = UNC_PATH_PATTERN.matcher(uncPath);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("UNC path '%s' did not match expected expression '%s'", uncPath, UNC_PATH_PATTERN));
        }
        return this.pathMapper.toLocalPath(matcher.group(1));
    }
}

