/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.replacer;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.engine.replacer.PlaceholderReplacer;
import com.xebialabs.deployit.engine.replacer.PlaceholderScanner;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.local.LocalFile;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileReader;
import de.schlichtherle.truezip.file.TFileWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Placeholders {
    public static Map<String, Pattern> patternMap = new MapMaker().makeComputingMap((Function)new Function<String, Pattern>(){

        public Pattern apply(String regex) {
            return Pattern.compile(regex, 6);
        }
    });
    private static final Logger logger = LoggerFactory.getLogger(Placeholders.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scanPlaceholders(SourceArtifact artifact, PlaceholderScanner scanner) {
        Preconditions.checkArgument((artifact.getFile() != null ? 1 : 0) != 0, (Object)(artifact + " has no file"));
        Preconditions.checkArgument((boolean)(artifact.getFile() instanceof LocalFile), (Object)("Cannot scan for placeholders in " + artifact + " because its file is a " + artifact.getFile().getClass().getName() + " and not a " + LocalFile.class.getName()));
        artifact.setPlaceholders((Set)Sets.newTreeSet());
        if (artifact.hasProperty("scanPlaceholders") && !((Boolean)artifact.getProperty("scanPlaceholders")).booleanValue()) {
            return;
        }
        TFile from = Placeholders.asTfile(artifact.getFile());
        try {
            Placeholders.doScanPlaceholders(artifact, from, scanner);
        }
        finally {
            Placeholders.umountQuietly(from);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doScanPlaceholders(SourceArtifact artifact, TFile from, PlaceholderScanner scanner) {
        if (Placeholders.shouldExcludeFile(from, artifact.getExcludeFileNamesRegex())) {
            return;
        }
        if (from.isDirectory()) {
            try {
                for (TFile f : from.listFiles()) {
                    f = Placeholders.asTfile((File)f);
                    Placeholders.doScanPlaceholders(artifact, f, scanner);
                }
            }
            finally {
                Placeholders.umountQuietly(from);
            }
        } else if (Placeholders.isTextFile(from, artifact.getTextFileNamesRegex())) {
            artifact.getPlaceholders().addAll(Placeholders.readPlaceholders(from, scanner));
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Set<String> readPlaceholders(TFile from, PlaceholderScanner scanner) {
        Set<String> set;
        TFileReader in = null;
        try {
            logger.trace("Reading placeholders from file {}", (Object)from.getPath());
            in = new TFileReader(from);
            set = scanner.scan((Reader)in);
        }
        catch (IOException exc) {
            try {
                throw new RuntimeIOException("Cannot scan for placeholders in " + from, (Throwable)exc);
                catch (RuntimeException exc2) {
                    throw new RuntimeException("Cannot scan for placeholders in " + from, exc2);
                }
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(in);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)in);
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replacePlaceholders(DerivedArtifact<? extends SourceArtifact> derivedArtifact, PlaceholderReplacer replacer) {
        block9: {
            if (derivedArtifact.getSourceArtifact() == null) {
                derivedArtifact.setFile(null);
            } else {
                OverthereFile fromFile = derivedArtifact.getSourceArtifact().getFile();
                Preconditions.checkArgument((fromFile != null ? 1 : 0) != 0, (String)"%s has no file", (Object[])new Object[]{derivedArtifact.getSourceArtifact()});
                Preconditions.checkArgument((boolean)(fromFile instanceof LocalFile), (String)"Cannot replace placeholders in %s because its file is not a LocalFile but a %s", (Object[])new Object[]{derivedArtifact.getSourceArtifact(), fromFile.getClass().getName()});
                TFile from = Placeholders.asTfile(fromFile);
                try {
                    boolean isBinaryFile;
                    boolean bl = isBinaryFile = from.isFile() && !Placeholders.isTextFile(from, Placeholders.getTextFileNamesRegex(derivedArtifact));
                    if (derivedArtifact.getPlaceholders().isEmpty() || isBinaryFile) {
                        derivedArtifact.setFile(fromFile);
                        break block9;
                    }
                    TFile to = Placeholders.getOutputFile(derivedArtifact);
                    try {
                        Placeholders.doReplacePlaceholders(derivedArtifact, from, to, replacer);
                        File deployedFile = Placeholders.saveArchive(to);
                        derivedArtifact.setFile(LocalFile.valueOf((File)deployedFile));
                    }
                    finally {
                        Placeholders.umountQuietly(to);
                    }
                }
                finally {
                    Placeholders.umountQuietly(from);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doReplacePlaceholders(DerivedArtifact<? extends SourceArtifact> derivedArtifact, TFile from, TFile to, PlaceholderReplacer replacer) {
        boolean include;
        boolean bl = include = !Placeholders.shouldExcludeFile(from, Placeholders.getExcludeFileNamesRegex(derivedArtifact));
        if (include && from.isDirectory()) {
            try {
                Placeholders.mkdir(to);
                for (TFile f : from.listFiles()) {
                    f = Placeholders.asTfile((File)f);
                    TFile t = Placeholders.getToFile(to, f);
                    Placeholders.doReplacePlaceholders(derivedArtifact, f, t, replacer);
                }
            }
            finally {
                Placeholders.umountQuietly(from);
                Placeholders.umountQuietly(to);
            }
        }
        if (include && Placeholders.isTextFile(from, Placeholders.getTextFileNamesRegex(derivedArtifact))) {
            Placeholders.replace(from, to, replacer, derivedArtifact.getPlaceholders());
        } else {
            try {
                from.cp_rp((File)to);
            }
            catch (IOException exc) {
                throw new RuntimeIOException("Cannot copy " + from + " to " + to, (Throwable)exc);
            }
        }
    }

    private static void mkdir(TFile to) {
        try {
            to.mkdir(false);
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Cannot create directory " + to, (Throwable)exc);
        }
    }

    private static void replace(TFile from, TFile to, PlaceholderReplacer replacer, Map<String, String> resolution) {
        TFileReader reader = null;
        TFileWriter writer = null;
        try {
            reader = new TFileReader(from);
            writer = new TFileWriter(to);
            replacer.replace((Reader)reader, (Writer)writer, resolution);
        }
        catch (IOException exc) {
            try {
                throw new RuntimeIOException("Cannot copy " + from + " to " + to + " while replacing placeholders", (Throwable)exc);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(reader);
                Closeables.closeQuietly(writer);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)reader);
        Closeables.closeQuietly((Closeable)writer);
    }

    private static final TFile getOutputFile(DerivedArtifact<? extends SourceArtifact> derivedArtifact) {
        String baseName;
        OverthereFile sourceFile = derivedArtifact.getSourceArtifact().getFile();
        OverthereFile workDir = sourceFile.getParentFile();
        Random r = new Random();
        String name = baseName = derivedArtifact.getName();
        while (true) {
            OverthereFile deployedArtifactDir;
            if (!(deployedArtifactDir = workDir.getFile(name)).exists()) {
                deployedArtifactDir.mkdir();
                TFile dir = new TFile(((LocalFile)deployedArtifactDir).getFile(), TArchiveDetector.NULL);
                if (sourceFile.isDirectory()) {
                    return new TFile((File)dir, sourceFile.getName(), TArchiveDetector.NULL);
                }
                return new TFile((File)dir, sourceFile.getName(), TArchiveDetector.ALL);
            }
            name = baseName + Math.abs(r.nextInt());
        }
    }

    private static File saveArchive(TFile outputArchive) {
        if (outputArchive.isArchive() && outputArchive.getEnclArchive() == null && outputArchive.isDirectory()) {
            try {
                TFile.umount((TFile)outputArchive);
            }
            catch (IOException exc) {
                throw new RuntimeIOException("Cannot write archive " + outputArchive, (Throwable)exc);
            }
        }
        return new File(outputArchive.getPath());
    }

    private static boolean shouldExcludeFile(TFile f, String excludeFileNamesRegex) {
        if (Strings.emptyToNull((String)excludeFileNamesRegex) == null) {
            return false;
        }
        Pattern excludeFileNamesPattern = patternMap.get(excludeFileNamesRegex);
        Matcher excludeFileNamesMatcher = excludeFileNamesPattern.matcher(f.getPath());
        boolean exclude = excludeFileNamesMatcher.matches();
        if (exclude) {
            logger.debug("Excluding file {} from scanning", (Object)f);
        }
        return exclude;
    }

    private static String getExcludeFileNamesRegex(DerivedArtifact<? extends SourceArtifact> derivedArtifact) {
        return derivedArtifact.getSourceArtifact().getExcludeFileNamesRegex();
    }

    private static boolean isTextFile(TFile f, String textFileNamesRegex) {
        Preconditions.checkNotNull((Object)textFileNamesRegex, (Object)"Regex is null");
        Pattern textFileNamesPattern = patternMap.get(textFileNamesRegex);
        Matcher textFileNamesMatcher = textFileNamesPattern.matcher(f.getName());
        boolean isTextFile = textFileNamesMatcher.matches();
        logger.debug("Determined {} to be a {} file", (Object)f.getName(), (Object)(isTextFile ? "text" : "binary"));
        return isTextFile;
    }

    private static String getTextFileNamesRegex(DerivedArtifact<? extends SourceArtifact> derivedArtifact) {
        return derivedArtifact.getSourceArtifact().getTextFileNamesRegex();
    }

    private static TFile asTfile(OverthereFile file) {
        File fromFile = ((LocalFile)file).getFile();
        return Placeholders.asTfile(fromFile);
    }

    private static TFile asTfile(File fromFile) {
        File from = fromFile;
        if (from instanceof TFile) {
            from = ((TFile)from).getFile();
        }
        if (from.isDirectory()) {
            return new TFile(from, TArchiveDetector.NULL);
        }
        return new TFile(from);
    }

    private static TFile getToFile(TFile parent, TFile from) {
        return new TFile((File)parent, from.getName(), TArchiveDetector.ALL);
    }

    private static void umountQuietly(TFile file) {
        if (file != null && file.isArchive() && file.getEnclArchive() == null) {
            try {
                TFile.umount((TFile)file);
            }
            catch (Exception e) {
                logger.error("Couldn't umount [{}], ignoring exception.", (Object)file);
                logger.debug("Exception while umounting was: ", (Throwable)e);
            }
        }
    }
}

