/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.instrument.classloading.jboss;

import java.lang.instrument.ClassFileTransformer;
import org.springframework.instrument.classloading.LoadTimeWeaver;
import org.springframework.instrument.classloading.SimpleThrowawayClassLoader;
import org.springframework.instrument.classloading.jboss.JBossClassLoaderAdapter;
import org.springframework.instrument.classloading.jboss.JBossMCAdapter;
import org.springframework.instrument.classloading.jboss.JBossModulesAdapter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class JBossLoadTimeWeaver
implements LoadTimeWeaver {
    private final JBossClassLoaderAdapter adapter;

    public JBossLoadTimeWeaver() {
        this(ClassUtils.getDefaultClassLoader());
    }

    public JBossLoadTimeWeaver(ClassLoader classLoader) {
        Assert.notNull((Object)classLoader, (String)"ClassLoader must not be null");
        this.adapter = classLoader.getClass().getName().startsWith("org.jboss.modules") ? new JBossModulesAdapter(classLoader) : new JBossMCAdapter(classLoader);
    }

    public void addTransformer(ClassFileTransformer transformer) {
        this.adapter.addTransformer(transformer);
    }

    public ClassLoader getInstrumentableClassLoader() {
        return this.adapter.getInstrumentableClassLoader();
    }

    public ClassLoader getThrowawayClassLoader() {
        return new SimpleThrowawayClassLoader(this.getInstrumentableClassLoader());
    }
}

