/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.hdf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HDFParser
implements Parser {
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.application((String)"x-hdf"));

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.writeStreamToMemory(stream, os);
        NetcdfFile ncFile = NetcdfFile.openInMemory((String)"", (byte[])os.toByteArray());
        this.unravelStringMet(ncFile, null, metadata);
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        this.parse(stream, handler, metadata, new ParseContext());
    }

    protected void unravelStringMet(NetcdfFile ncFile, Group group, Metadata met) {
        if (group == null) {
            group = ncFile.getRootGroup();
        }
        for (Attribute attribute : group.getAttributes()) {
            if (attribute.isString()) {
                met.add(attribute.getName(), attribute.getStringValue());
                continue;
            }
            met.add(attribute.getName(), String.valueOf(attribute.getNumericValue()));
        }
        for (Group g : group.getGroups()) {
            this.unravelStringMet(ncFile, g, met);
        }
    }

    protected void writeStreamToMemory(InputStream is, ByteArrayOutputStream os) throws TikaException {
        byte[] buf = new byte[512];
        try {
            while (is.read(buf, 0, 512) != -1) {
                os.write(buf);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TikaException(e.getMessage());
        }
    }
}

