/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.overthere.step;

import com.google.common.base.Throwables;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.overthere.DefaultProcessOutputHandler;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcessOutputHandler;
import com.xebialabs.overthere.util.OverthereUtils;
import java.io.Closeable;

public class CheckConnectionStep
implements Step {
    private Host host;

    public CheckConnectionStep(Host host) {
        this.host = host;
    }

    public String getDescription() {
        return "Check connection to " + this.host.getId();
    }

    public int getOrder() {
        return 50;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        DefaultProcessOutputHandler handler = new DefaultProcessOutputHandler(ctx);
        try {
            String hostName = this.host.getName();
            if (this.host.hasProperty("address")) {
                hostName = (String)this.host.getProperty("address");
            }
            try {
                OverthereConnection connection = this.host.getConnection();
                try {
                    ctx.logOutput("Attempting to list the contents of the temporary directory");
                    ctx.logOutput("----------------------------------------------------------");
                    this.echoTmpDirContents(connection, handler);
                    ctx.logOutput("----------------------------------------------------------");
                    ctx.logOutput("Uploading file to the temporary directory");
                    ctx.logOutput("----------------------------------------------------------");
                    OverthereFile fileToUpload = CheckConnectionStep.uploadFile(connection);
                    ctx.logOutput("-----------------------------------------");
                    ctx.logOutput("Checking read permission of uploaded file");
                    ctx.logOutput("-----------------------------------------");
                    CheckConnectionStep.tryCanGetFilePermissions(connection, fileToUpload);
                    ctx.logOutput("-----------------------------------------");
                }
                finally {
                    Closeables.closeQuietly((Closeable)connection);
                }
            }
            catch (Exception exc) {
                handler.handleErrorLine(String.format("Connection test to host " + hostName + " failed. Please check address, username and password. Exception message is: %s%n%s", exc, Throwables.getStackTraceAsString((Throwable)exc)));
                StepExitCode stepExitCode = StepExitCode.FAIL;
                handler.close();
                return stepExitCode;
            }
            handler.handleOutputLine("Connection test to host " + hostName + " succeeded");
            StepExitCode stepExitCode = StepExitCode.SUCCESS;
            return stepExitCode;
        }
        finally {
            handler.close();
        }
    }

    private void echoTmpDirContents(OverthereConnection connection, OverthereProcessOutputHandler handler) {
        CmdLine cmdLine = new CmdLine();
        if (connection.getHostOperatingSystem() == OperatingSystemFamily.UNIX) {
            cmdLine.addArgument("ls");
        } else {
            cmdLine.addArgument("cmd");
            cmdLine.addArgument("/c");
            cmdLine.addArgument("dir");
        }
        String tempDir = this.host.getTemporaryDirectoryPath();
        if (tempDir == null) {
            tempDir = connection.getHostOperatingSystem().getDefaultTemporaryDirectoryPath();
        }
        cmdLine.addArgument(tempDir);
        connection.execute(handler, cmdLine);
    }

    private static OverthereFile uploadFile(OverthereConnection connection) {
        OverthereFile fileToUpload = connection.getTempFile("hostconnection-remote", ".txt");
        OverthereUtils.write((String)"Contents of host connection test file", (String)"UTF-8", (OverthereFile)fileToUpload);
        return fileToUpload;
    }

    private static void tryCanGetFilePermissions(OverthereConnection connection, OverthereFile uploadedFile) {
        OverthereFile filesJustUploadedNotAsATempFile = connection.getFile(uploadedFile.getPath());
        if (!filesJustUploadedNotAsATempFile.canRead()) {
            throw new RuntimeException("Cannot check read permission for file just uploaded");
        }
    }
}

