/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.xml;

import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.xebialabs.deployit.core.AbstractStringView;
import com.xebialabs.deployit.core.MapStringStringView;
import com.xebialabs.deployit.engine.api.dto.ValidatedConfigurationItem;
import com.xebialabs.deployit.engine.xml.AbstractConfigurationItemConverter;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.deployit.repository.StringValueConverter;
import com.xebialabs.deployit.util.PasswordEncrypter;
import java.util.Collection;
import java.util.List;

public class ConfigurationItemWriter
extends AbstractConfigurationItemConverter {
    protected PasswordEncrypter passwordEncrypter = PasswordEncrypter.getInstance();

    protected void writeStringProperty(Object value, PropertyDescriptor propertyDescriptor, HierarchicalStreamWriter writer) {
        if (propertyDescriptor.isPassword()) {
            writer.setValue(this.passwordEncrypter.ensureEncrypted(value.toString()));
        } else {
            super.writeStringProperty(value, propertyDescriptor, writer);
        }
    }

    protected void writeCollectionOfStringProperty(Object value, PropertyDescriptor propertyDescriptor, HierarchicalStreamWriter writer) {
        if (value instanceof AbstractStringView) {
            value = Collections2.transform(((AbstractStringView)value).getWrapped(), StringValueConverter.valueToString(this.passwordEncrypter, true));
        }
        super.writeCollectionOfStringProperty(value, propertyDescriptor, writer);
    }

    protected void writeMapStringStringProperty(Object value, PropertyDescriptor propertyDescriptor, HierarchicalStreamWriter writer) {
        if (value instanceof MapStringStringView) {
            value = Maps.transformValues(((MapStringStringView)value).getWrapped(), StringValueConverter.valueToString(this.passwordEncrypter, true));
        }
        super.writeMapStringStringProperty(value, propertyDescriptor, writer);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Object toBeMarshalled = source;
        if (source instanceof ValidatedConfigurationItem) {
            toBeMarshalled = ((ValidatedConfigurationItem)source).getWrapped();
        }
        super.marshal(toBeMarshalled, writer, context);
        if (source instanceof ValidatedConfigurationItem) {
            List validations = ((ValidatedConfigurationItem)source).getValidations();
            writer.startNode("validation-messages");
            for (ValidationMessage validation : validations) {
                writer.startNode("validation-message");
                writer.addAttribute("ci", validation.getCiId());
                if (validation.getPropertyName() != null) {
                    writer.addAttribute("property", validation.getPropertyName());
                }
                writer.setValue(validation.getMessage());
                writer.endNode();
            }
            writer.endNode();
        }
    }

    protected void writeCiProperty(Object value, PropertyDescriptor propertyDescriptor, HierarchicalStreamWriter writer) {
        writer.addAttribute("ref", ((ConfigurationItem)value).getId());
    }

    protected void writeCollectionOfCiProperty(Object value, PropertyDescriptor propertyDescriptor, HierarchicalStreamWriter writer) {
        for (ConfigurationItem configurationItem : (Collection)value) {
            writer.startNode("ci");
            writer.addAttribute("ref", configurationItem.getId());
            writer.endNode();
        }
    }

    protected void readCiProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, HierarchicalStreamReader reader) {
    }

    protected void readCollectionOfCiProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, HierarchicalStreamReader reader) {
    }
}

