/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemException;
import org.apache.jackrabbit.core.fs.FileSystemPathUtil;

public class FileSystemResource {
    protected final FileSystem fs;
    protected final String path;

    public FileSystemResource(FileSystem fs, String path) {
        if (fs == null) {
            throw new IllegalArgumentException("invalid file system argument");
        }
        this.fs = fs;
        if (path == null) {
            throw new IllegalArgumentException("invalid path argument");
        }
        this.path = path;
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    public String getPath() {
        return this.path;
    }

    public String getParentDir() {
        return FileSystemPathUtil.getParentDir(this.path);
    }

    public String getName() {
        return FileSystemPathUtil.getName(this.path);
    }

    public synchronized void makeParentDirs() throws FileSystemException {
        String parentDir = this.getParentDir();
        if (!this.fs.exists(parentDir)) {
            this.fs.createFolder(parentDir);
        }
    }

    public void delete() throws FileSystemException {
        this.delete(false);
    }

    public synchronized void delete(boolean pruneEmptyParentDirs) throws FileSystemException {
        this.fs.deleteFile(this.path);
        if (pruneEmptyParentDirs) {
            String parentDir = FileSystemPathUtil.getParentDir(this.path);
            while (!parentDir.equals("/") && this.fs.exists(parentDir) && !this.fs.hasChildren(parentDir)) {
                this.fs.deleteFolder(parentDir);
                parentDir = FileSystemPathUtil.getParentDir(parentDir);
            }
        }
    }

    public boolean exists() throws FileSystemException {
        return this.fs.exists(this.path);
    }

    public InputStream getInputStream() throws FileSystemException {
        return this.fs.getInputStream(this.path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void spool(OutputStream out) throws FileSystemException, IOException {
        InputStream in = this.fs.getInputStream(this.path);
        try {
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public OutputStream getOutputStream() throws FileSystemException {
        return this.fs.getOutputStream(this.path);
    }

    public long lastModified() throws FileSystemException {
        return this.fs.lastModified(this.path);
    }

    public long length() throws FileSystemException {
        return this.fs.length(this.path);
    }

    public String toString() {
        return this.getPath();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FileSystemResource) {
            FileSystemResource other = (FileSystemResource)obj;
            return (this.path == null ? other.path == null : this.path.equals(other.path)) && (this.fs == null ? other.fs == null : this.fs.equals(other.fs));
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    static {
        FileSystemPathUtil.class.hashCode();
    }
}

