/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.cifs.winrm.exception;

import com.xebialabs.overthere.RuntimeIOException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class WinRMRuntimeIOException
extends RuntimeIOException {
    final Document in;
    final Document out;

    public WinRMRuntimeIOException(String message, Document in, Document out, Throwable cause) {
        super(message, cause);
        this.in = in;
        this.out = out;
    }

    public WinRMRuntimeIOException(String message) {
        this(message, null, null, null);
    }

    public WinRMRuntimeIOException(String message, Throwable throwable) {
        this(message, null, null, throwable);
    }

    @Override
    public String getMessage() {
        return String.format("%s, document in %s, document out %s,", super.getMessage(), WinRMRuntimeIOException.toString(this.in), WinRMRuntimeIOException.toString(this.out));
    }

    private static String toString(Document doc) {
        if (doc == null) {
            return "[EMPTY]";
        }
        StringWriter stringWriter = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, OutputFormat.createPrettyPrint());
        try {
            xmlWriter.write(doc);
            xmlWriter.close();
        }
        catch (IOException e) {
            throw new RuntimeException("error ", e);
        }
        return stringWriter.toString();
    }
}

