/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.engine.xml;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractConfigurationItemConverter
implements Converter {
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        ConfigurationItem ci = (ConfigurationItem)source;
        writer.addAttribute("id", ci.getId());
        if (ci instanceof BaseConfigurationItem) {
            writer.addAttribute("token", Strings.nullToEmpty((String)((BaseConfigurationItem)ci).get$token()));
        }
        this.writeProperties(ci, writer);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Type type = Type.valueOf((String)reader.getNodeName());
        String id = reader.getAttribute("id");
        Descriptor descriptor = type.getDescriptor();
        if (descriptor == null) {
            throw new IllegalStateException("Encountered unknown CI type [" + type + "] for ConfigurationItem [" + id + "]");
        }
        ConfigurationItem configurationItem = descriptor.newInstance();
        configurationItem.setId(id);
        if (configurationItem instanceof BaseConfigurationItem) {
            ((BaseConfigurationItem)configurationItem).set$token(reader.getAttribute("token"));
        }
        configurationItem = this.readProperties(reader, descriptor, configurationItem);
        return configurationItem;
    }

    protected void writeProperties(ConfigurationItem ci, HierarchicalStreamWriter writer) {
        for (PropertyDescriptor propertyDescriptor : ci.getType().getDescriptor().getPropertyDescriptors()) {
            if (propertyDescriptor.isHidden()) continue;
            this.writeProperty(ci, propertyDescriptor, writer);
        }
    }

    protected void writeProperty(ConfigurationItem ci, PropertyDescriptor propertyDescriptor, HierarchicalStreamWriter writer) {
        Object value = propertyDescriptor.get(ci);
        if (value == null) {
            return;
        }
        writer.startNode(propertyDescriptor.getName());
        switch (propertyDescriptor.getKind()) {
            case STRING: {
                this.writeStringProperty(value, propertyDescriptor, writer);
                break;
            }
            case BOOLEAN: 
            case INTEGER: 
            case ENUM: {
                writer.setValue(value.toString());
                break;
            }
            case CI: {
                this.writeCiProperty(value, propertyDescriptor, writer);
                break;
            }
            case SET_OF_STRING: 
            case LIST_OF_STRING: {
                this.writeCollectionOfStringProperty(value, propertyDescriptor, writer);
                break;
            }
            case SET_OF_CI: 
            case LIST_OF_CI: {
                this.writeCollectionOfCiProperty(value, propertyDescriptor, writer);
                break;
            }
            case MAP_STRING_STRING: {
                this.writeMapStringStringProperty(value, propertyDescriptor, writer);
            }
        }
        writer.endNode();
    }

    protected void writeStringProperty(Object value, PropertyDescriptor propertyDescriptor, HierarchicalStreamWriter writer) {
        writer.setValue(value.toString());
    }

    protected void writeMapStringStringProperty(Object value, PropertyDescriptor propertyDescriptor, HierarchicalStreamWriter writer) {
        for (Map.Entry entry : ((Map)value).entrySet()) {
            writer.startNode("entry");
            writer.addAttribute("key", (String)entry.getKey());
            writer.setValue((String)entry.getValue());
            writer.endNode();
        }
    }

    protected void writeCollectionOfStringProperty(Object value, PropertyDescriptor propertyDescriptor, HierarchicalStreamWriter writer) {
        for (String s : (Collection)value) {
            writer.startNode("value");
            writer.setValue(s);
            writer.endNode();
        }
    }

    protected ConfigurationItem readProperties(HierarchicalStreamReader reader, Descriptor descriptor, ConfigurationItem configurationItem) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            this.readProperty(reader, descriptor, configurationItem);
            reader.moveUp();
        }
        return configurationItem;
    }

    protected void readProperty(HierarchicalStreamReader reader, Descriptor descriptor, ConfigurationItem configurationItem) {
        String propName = reader.getNodeName();
        PropertyDescriptor propertyDescriptor = descriptor.getPropertyDescriptor(propName);
        if (propertyDescriptor == null) {
            throw new IllegalStateException("Encountered unknown ConfigurationItem property [" + descriptor.getType() + "." + propName + "] for ci [" + configurationItem.getId() + "]");
        }
        switch (propertyDescriptor.getKind()) {
            case STRING: {
                this.readStringProperty(configurationItem, propertyDescriptor, reader);
                break;
            }
            case BOOLEAN: 
            case INTEGER: 
            case ENUM: {
                propertyDescriptor.set(configurationItem, (Object)reader.getValue());
                break;
            }
            case CI: {
                this.readCiProperty(configurationItem, propertyDescriptor, reader);
                break;
            }
            case SET_OF_STRING: 
            case LIST_OF_STRING: {
                this.readCollectionOfStringProperty(configurationItem, propertyDescriptor, reader);
                break;
            }
            case SET_OF_CI: 
            case LIST_OF_CI: {
                this.readCollectionOfCiProperty(configurationItem, propertyDescriptor, reader);
                break;
            }
            case MAP_STRING_STRING: {
                this.readMapStringStringProperty(configurationItem, propertyDescriptor, reader);
            }
        }
    }

    protected void readStringProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, HierarchicalStreamReader reader) {
        propertyDescriptor.set(configurationItem, (Object)reader.getValue());
    }

    protected void readMapStringStringProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, HierarchicalStreamReader reader) {
        HashMap map = Maps.newHashMap();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            map.put(reader.getAttribute("key"), reader.getValue());
            reader.moveUp();
        }
        propertyDescriptor.set(configurationItem, (Object)map);
    }

    protected void readCollectionOfStringProperty(ConfigurationItem configurationItem, PropertyDescriptor propertyDescriptor, HierarchicalStreamReader reader) {
        AbstractCollection strings;
        AbstractCollection abstractCollection = strings = propertyDescriptor.getKind() == PropertyKind.SET_OF_STRING ? Sets.newHashSet() : Lists.newArrayList();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            strings.add(reader.getValue());
            reader.moveUp();
        }
        propertyDescriptor.set(configurationItem, (Object)strings);
    }

    public boolean canConvert(Class type) {
        return ConfigurationItem.class.isAssignableFrom(type);
    }

    protected abstract void writeCiProperty(Object var1, PropertyDescriptor var2, HierarchicalStreamWriter var3);

    protected abstract void writeCollectionOfCiProperty(Object var1, PropertyDescriptor var2, HierarchicalStreamWriter var3);

    protected abstract void readCiProperty(ConfigurationItem var1, PropertyDescriptor var2, HierarchicalStreamReader var3);

    protected abstract void readCollectionOfCiProperty(ConfigurationItem var1, PropertyDescriptor var2, HierarchicalStreamReader var3);
}

