/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.cifs.winrm;

import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.cifs.CifsConnection;
import com.xebialabs.overthere.cifs.CifsConnectionBuilder;
import com.xebialabs.overthere.cifs.WinrmHttpsCertificateTrustStrategy;
import com.xebialabs.overthere.cifs.WinrmHttpsHostnameVerificationStrategy;
import com.xebialabs.overthere.cifs.winrm.WinRmClient;
import com.xebialabs.overthere.cifs.winrm.connector.ApacheHttpComponentsHttpClientHttpConnector;
import com.xebialabs.overthere.cifs.winrm.exception.WinRMRuntimeIOException;
import com.xebialabs.overthere.spi.AddressPortMapper;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class CifsWinRmConnection
extends CifsConnection {
    private ConnectionOptions options;
    private URL targetURL;
    private ApacheHttpComponentsHttpClientHttpConnector httpConnector;

    public CifsWinRmConnection(String type, ConnectionOptions options, AddressPortMapper mapper) {
        super(type, options, mapper, false);
        Preconditions.checkArgument((this.os == OperatingSystemFamily.WINDOWS ? 1 : 0) != 0, (String)"Cannot start a cifs:%s connection to a non-Windows operating system", (Object[])new Object[]{this.cifsConnectionType.toString().toLowerCase()});
        Preconditions.checkArgument((!this.username.contains("\\") ? 1 : 0) != 0, (String)"Cannot start a cifs:%s connection with an old-style Windows domain account [%s], use USER@DOMAIN instead.", (Object[])new Object[]{this.cifsConnectionType.toString().toLowerCase(), this.username});
        this.options = options;
        this.targetURL = this.getTargetURL(options);
        this.httpConnector = this.createHttpConnector(this.targetURL, options);
    }

    private URL getTargetURL(ConnectionOptions options) {
        String scheme = options.getBoolean("winrmEnableHttps", false) ? "https" : "http";
        String context = options.get("winrmContext", "/wsman");
        try {
            return new URL(scheme, this.address, this.port, context);
        }
        catch (MalformedURLException e) {
            throw new WinRMRuntimeIOException("Cannot build a new URL for " + this, e);
        }
    }

    private ApacheHttpComponentsHttpClientHttpConnector createHttpConnector(URL targetURL, ConnectionOptions options) {
        ApacheHttpComponentsHttpClientHttpConnector httpConnector = new ApacheHttpComponentsHttpClientHttpConnector(this.username, this.password, targetURL);
        httpConnector.setHttpsCertTrustStrategy(options.getEnum("winrmHttpsCertificateTrustStrategy", WinrmHttpsCertificateTrustStrategy.class, CifsConnectionBuilder.DEFAULT_WINRM_HTTPS_CERTIFICATE_TRUST_STRATEGY));
        httpConnector.setHttpsHostnameVerifyStrategy(options.getEnum("winrmHttpsHostnameVerificationStrategy", WinrmHttpsHostnameVerificationStrategy.class, CifsConnectionBuilder.DEFAULT_WINRM_HTTPS_HOSTNAME_VERIFICATION_STRATEGY));
        httpConnector.setKerberosUseHttpSpn(options.getBoolean("winrmKerberosUseHttpSpn", false));
        httpConnector.setKerberosAddPortToSpn(options.getBoolean("winrmKerberosAddPortToSpn", false));
        httpConnector.setKerberosDebug(options.getBoolean("winrmKerberosDebug", false));
        return httpConnector;
    }

    private WinRmClient createWinrmClient(URL targetURL, ApacheHttpComponentsHttpClientHttpConnector httpConnector, ConnectionOptions options) {
        WinRmClient client = new WinRmClient(httpConnector, targetURL);
        client.setTimeout(options.get("winrmTimeout", "PT60.000S"));
        client.setEnvelopSize(options.get("winrmEnvelopSize", 153600));
        client.setLocale(options.get("winrmLocale", "en-US"));
        return client;
    }

    @Override
    public OverthereProcess startProcess(final CmdLine commandLine) {
        final String obfuscatedCommandLine = commandLine.toCommandLine(this.getHostOperatingSystem(), true);
        String cmd = commandLine.toCommandLine(this.getHostOperatingSystem(), false);
        if (this.workingDirectory != null) {
            cmd = "CD /D " + this.workingDirectory.getPath() + " & " + cmd;
        }
        final WinRmClient winRmClient = this.createWinrmClient(this.targetURL, this.httpConnector, this.options);
        try {
            final PipedInputStream callersStdout = new PipedInputStream();
            final PipedOutputStream toCallersStdout = new PipedOutputStream(callersStdout);
            final PipedInputStream callersStderr = new PipedInputStream();
            final PipedOutputStream toCallersStderr = new PipedOutputStream(callersStderr);
            winRmClient.startCmd(cmd);
            final Thread processOutputReaderThread = new Thread(String.format("Process output reader for command [%s] on [%s]", obfuscatedCommandLine, this)){

                @Override
                public void run() {
                    try {
                        while (winRmClient.receiveOutput(toCallersStdout, toCallersStderr)) {
                        }
                    }
                    catch (IOException exc) {
                        throw new RuntimeIOException("Cannot start process " + commandLine, exc);
                    }
                    finally {
                        Closeables.closeQuietly((Closeable)toCallersStdout);
                        Closeables.closeQuietly((Closeable)toCallersStderr);
                    }
                }
            };
            processOutputReaderThread.start();
            return new OverthereProcess(){
                boolean processTerminated = false;

                @Override
                public synchronized OutputStream getStdin() {
                    return new ByteArrayOutputStream();
                }

                @Override
                public synchronized InputStream getStdout() {
                    return callersStdout;
                }

                @Override
                public synchronized InputStream getStderr() {
                    return callersStderr;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public synchronized int waitFor() {
                    if (this.processTerminated) {
                        return this.exitValue();
                    }
                    try {
                        try {
                            processOutputReaderThread.join();
                        }
                        finally {
                            winRmClient.deleteShell();
                            this.processTerminated = true;
                        }
                        return this.exitValue();
                    }
                    catch (InterruptedException exc) {
                        throw new RuntimeIOException(String.format("Cannot execute command [%s] on [%s]", obfuscatedCommandLine, CifsWinRmConnection.this), exc);
                    }
                }

                @Override
                public synchronized void destroy() {
                    if (this.processTerminated) {
                        return;
                    }
                    winRmClient.signal();
                    winRmClient.deleteShell();
                    this.processTerminated = true;
                }

                @Override
                public synchronized int exitValue() {
                    if (!this.processTerminated) {
                        throw new IllegalThreadStateException(String.format("Process for command [%s] on [%s] is still running", obfuscatedCommandLine, CifsWinRmConnection.this));
                    }
                    return winRmClient.exitValue();
                }
            };
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Cannot execute command " + commandLine + " on " + this, exc);
        }
    }
}

