/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.ssh;

import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereExecutionOutputHandler;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.RuntimeIOException;
import com.xebialabs.overthere.spi.BaseOverthereConnection;
import com.xebialabs.overthere.spi.BaseOverthereFile;
import com.xebialabs.overthere.ssh.SshConnection;

abstract class SshFile<C extends SshConnection>
extends BaseOverthereFile<C> {
    protected String path;

    SshFile(C connection, String path) {
        super(connection);
        this.path = ((BaseOverthereConnection)connection).getHostOperatingSystem() != OperatingSystemFamily.WINDOWS ? path : path.replace('/', '\\');
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public boolean isHidden() {
        return this.getName().startsWith(".");
    }

    @Override
    public String getName() {
        String fileSep = ((SshConnection)this.connection).getHostOperatingSystem().getFileSeparator();
        int lastFileSepPos = this.path.lastIndexOf(fileSep);
        if (lastFileSepPos < 0) {
            return this.path;
        }
        return this.path.substring(lastFileSepPos + 1);
    }

    @Override
    public OverthereFile getParentFile() {
        String fileSep = ((SshConnection)this.connection).getHostOperatingSystem().getFileSeparator();
        int lastFileSepPos = this.path.lastIndexOf(fileSep);
        if (lastFileSepPos < 0 || this.path.equals(fileSep)) {
            return null;
        }
        if (lastFileSepPos == 0) {
            return ((SshConnection)this.connection).getFile(fileSep);
        }
        return ((SshConnection)this.connection).getFile(this.path.substring(0, lastFileSepPos));
    }

    @Override
    public void delete() throws RuntimeIOException {
        if (this.exists()) {
            if (this.isDirectory()) {
                this.deleteDirectory();
            } else {
                this.deleteFile();
            }
        }
    }

    protected abstract void deleteFile();

    protected abstract void deleteDirectory();

    protected int executeCommand(OverthereExecutionOutputHandler outHandler, OverthereExecutionOutputHandler errHandler, CmdLine commandLine) {
        return ((SshConnection)this.connection).execute(outHandler, errHandler, commandLine);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SshFile)) {
            return false;
        }
        return this.path.equals(((SshFile)obj).getPath());
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    @Override
    public String toString() {
        String p = this.getPath();
        if (p.length() >= 1 && p.charAt(0) == '/') {
            return this.getConnection() + p;
        }
        return this.getConnection() + "/" + p;
    }
}

