/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.rest.api.reports;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.core.api.dto.Report;
import com.xebialabs.deployit.core.rest.api.reports.TaskArchiveReport;
import com.xebialabs.deployit.core.rest.api.reports.TaskStateData;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskState;
import com.xebialabs.deployit.task.ArchivedTaskSearchParameters;
import com.xebialabs.deployit.task.FilterType;
import com.xebialabs.deployit.task.archive.ArchivedTask;
import com.xebialabs.deployit.task.archive.JcrTaskArchive;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeploymentsStateBreakdownReport
extends TaskArchiveReport {
    public DeploymentsStateBreakdownReport(JcrTaskArchive taskArchive) {
        super(taskArchive);
    }

    public Report report(final FilterType filterType, List<ConfigurationItemId> filterCriteria) {
        final HashMap tasks = Maps.newHashMap();
        for (ConfigurationItemId appOrEnvName : filterCriteria) {
            ArchivedTaskSearchParameters searchParameters = this.cloneSearchParameters();
            searchParameters.forFilterType(filterType, appOrEnvName);
            this.taskArchive.searchTasksWithoutLoadingSteps(searchParameters, new JcrTaskArchive.TaskCallback(){

                public void doWithTask(ArchivedTask task) {
                    DeploymentsStateBreakdownReport.incrementTaskCount(tasks, (TaskState)task, filterType);
                }
            });
        }
        for (ConfigurationItemId entityId : filterCriteria) {
            if (tasks.containsKey(entityId.getId())) continue;
            tasks.put(entityId.getId(), new TaskStateData());
        }
        return DeploymentsStateBreakdownReport.generateReportData(tasks);
    }

    private static Report generateReportData(Map<String, TaskStateData> tasks) {
        Report report = new Report();
        for (Map.Entry<String, TaskStateData> entry : tasks.entrySet()) {
            Report.ReportLine reportLine = report.addLine();
            reportLine.addValue("entityName", (Object)entry.getKey());
            reportLine.addValue("noOfSuccessfulDeployments", (Object)entry.getValue().getNoOfSuccessfulDeployments().toString());
        }
        return report;
    }

    private static void incrementTaskCount(Map<String, TaskStateData> tasks, TaskState task, FilterType filterType) {
        String entityId = DeploymentsStateBreakdownReport.getEntityId(task, filterType);
        if (task.getState() == TaskExecutionState.DONE) {
            TaskStateData taskStateData = tasks.get(entityId);
            if (taskStateData == null) {
                taskStateData = new TaskStateData();
                tasks.put(entityId, taskStateData);
            }
            taskStateData.getNoOfSuccessfulDeployments().incrementAndGet();
        }
    }

    private static String getEntityId(TaskState task, FilterType filterType) {
        String entityId = "";
        switch (filterType) {
            case APPLICATION: {
                entityId = (String)task.getMetadata().get("application");
                break;
            }
            case ENVIRONMENT: {
                entityId = (String)task.getMetadata().get("environment_id");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Report filter type, " + filterType + " is not supported");
            }
        }
        return entityId;
    }
}

