/*
 * Decompiled with CFR 0.152.
 */
package nl.javadude.scannit.metadata;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import javassist.bytecode.ClassFile;
import javassist.bytecode.Descriptor;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;

public class DescriptorHelper {
    private static List<String> primitiveNames = Lists.newArrayList((Object[])new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double"});
    private static List<String> primitiveDescriptors = Lists.newArrayList((Object[])new String[]{"Z", "B", "C", "S", "I", "J", "F", "D"});
    private static List<? extends Class<?>> primitiveClasses = Lists.newArrayList((Object[])new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE});

    public static String toTypeDescriptor(ClassFile file) {
        return file.getName();
    }

    public static String toMethodDescriptor(ClassFile file, MethodInfo method) {
        return DescriptorHelper.toTypeDescriptor(file) + "." + method.getName() + DescriptorHelper.parameters(method);
    }

    private static String parameters(MethodInfo method) {
        return Descriptor.toString((String)method.getDescriptor());
    }

    public static String tofieldDescriptor(ClassFile file, FieldInfo field) {
        return DescriptorHelper.toTypeDescriptor(file) + "." + field.getName();
    }

    public static Class<?> fromTypeDescriptor(String descriptor) {
        try {
            return Class.forName(descriptor, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Class not found for: " + descriptor, e);
        }
    }

    public static Method fromMethodDescriptor(String methodDescriptor) {
        int startParameterList = methodDescriptor.indexOf(40);
        int endParameterList = methodDescriptor.indexOf(41);
        String classAndMethodName = methodDescriptor.substring(0, startParameterList);
        int classMethodSep = classAndMethodName.lastIndexOf(46);
        Class<?> aClass = DescriptorHelper.fromTypeDescriptor(classAndMethodName.substring(0, classMethodSep));
        String methodName = classAndMethodName.substring(classMethodSep + 1, startParameterList);
        Object[] parameters = DescriptorHelper.parameters(methodDescriptor.substring(startParameterList + 1, endParameterList));
        try {
            return aClass.getMethod(methodName, (Class<?>[])parameters);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Method " + methodName + " with parameters: " + Arrays.toString(parameters) + " could not be located.", e);
        }
    }

    private static Class<?>[] parameters(String parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return new Class[0];
        }
        String[] paramDescriptors = parameters.split(", *");
        Class[] clazzes = new Class[paramDescriptors.length];
        for (int i = 0; i < paramDescriptors.length; ++i) {
            String paramDescriptor = paramDescriptors[i];
            if (DescriptorHelper.isPrimitive(paramDescriptor)) {
                clazzes[i] = primitiveClasses.get(primitiveNames.indexOf(paramDescriptor));
                continue;
            }
            String type = paramDescriptor;
            if (DescriptorHelper.isArray(paramDescriptor)) {
                String arrayType = paramDescriptor.substring(0, paramDescriptor.indexOf(91));
                type = DescriptorHelper.isPrimitive(arrayType) ? "[" + primitiveDescriptors.get(primitiveNames.indexOf(arrayType)) : "[L" + arrayType + ";";
            }
            try {
                clazzes[i] = Class.forName(type, false, Thread.currentThread().getContextClassLoader());
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Could not load class: " + paramDescriptor, e);
            }
        }
        return clazzes;
    }

    private static boolean isArray(String paramDescriptor) {
        return paramDescriptor.indexOf(91) != -1;
    }

    private static boolean isPrimitive(String paramDescriptor) {
        return primitiveNames.contains(paramDescriptor);
    }

    public static Field fromFieldDescriptor(String fieldDescriptor) {
        int lastDot = fieldDescriptor.lastIndexOf(46);
        String className = fieldDescriptor.substring(0, lastDot);
        String fieldName = fieldDescriptor.substring(lastDot + 1);
        Class<?> aClass = DescriptorHelper.fromTypeDescriptor(className);
        try {
            return aClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Field " + fieldName + " not found on class " + className, e);
        }
    }
}

