/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.reflect;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;

public abstract class DescriptorRegistry {
    private static final AtomicReference<DescriptorRegistry> REGISTRY = new AtomicReference();

    public static Collection<Descriptor> getDescriptors() {
        return REGISTRY.get()._getDescriptors();
    }

    public static Collection<Type> getSubtypes(Type supertype) {
        return REGISTRY.get()._getSubtypes(supertype);
    }

    public static Descriptor getDescriptor(String prefixedName) {
        return DescriptorRegistry.getDescriptor(Type.valueOf(prefixedName));
    }

    public static Descriptor getDescriptor(String prefix, String name) {
        return DescriptorRegistry.getDescriptor(Type.valueOf(prefix, name));
    }

    public static Descriptor getDescriptor(Type type) {
        return REGISTRY.get()._getDescriptor(type);
    }

    public static boolean exists(Type type) {
        return REGISTRY.get()._exists(type);
    }

    protected static DescriptorRegistry getInstance() {
        return REGISTRY.get();
    }

    protected abstract Collection<Descriptor> _getDescriptors();

    protected abstract Collection<Type> _getSubtypes(Type var1);

    protected abstract Descriptor _getDescriptor(Type var1);

    protected abstract boolean _exists(Type var1);

    static {
        ServiceLoader<DescriptorRegistry> registryLoader = ServiceLoader.load(DescriptorRegistry.class);
        ArrayList registries = Lists.newArrayList();
        Iterators.addAll((Collection)registries, registryLoader.iterator());
        Preconditions.checkState((registries.size() == 1 ? 1 : 0) != 0, (String)"Should have exactly 1 implementation of %s on the classpath (Found: %s)", (Object[])new Object[]{DescriptorRegistry.class.getName(), registries});
        REGISTRY.compareAndSet((DescriptorRegistry)null, (DescriptorRegistry)registries.get(0));
    }
}

