/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.upgrade;

import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.deployit.upgrade.RawRepositoryImpl;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.security.AccessControlPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deployit383AclClear
extends Upgrade {
    private static final Logger logger = LoggerFactory.getLogger(Deployit383AclClear.class);

    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        logger.info("*** Running Deployit 3.8.3 Upgrade: Clean policies ***");
        Session session = ((RawRepositoryImpl)repository).getSession();
        try {
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery("SELECT CI.* FROM [deployit:configurationItem] AS ci", "JCR-SQL2");
            QueryResult execute = query.execute();
            NodeIterator nodes = execute.getNodes();
            while (nodes.hasNext()) {
                AccessControlPolicy[] policies;
                Node node = nodes.nextNode();
                String path = node.getPath();
                if (node.hasNode("rep:policy")) {
                    logger.info("Found a rep:policy node under [{}], going to use the AccessControlManager to try to clear it.", (Object)path);
                }
                for (AccessControlPolicy policy : policies = session.getAccessControlManager().getPolicies(path)) {
                    logger.info("Found policy [{}] on node [{}]", (Object)policy, (Object)path);
                    session.getAccessControlManager().removePolicy(path, policy);
                }
            }
        }
        catch (RepositoryException e) {
            throw new UpgradeException("Failed to run 3.8.3 upgrade", (Exception)((Object)e));
        }
        logger.info("*** Finished upgrade ***");
        return true;
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)"deployit", (String)"3.8.3");
    }
}

