/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.jackrabbit.spi.commons.value.QValueValue;

public class NodeUtils {
    static Node getReferencedCiNode(Node node, Value value, Session session) throws RepositoryException {
        String referencedCiUuid = ((QValueValue)value).getQValue().getString();
        return NodeUtils.getNodeByUuid(node, referencedCiUuid, session);
    }

    protected static Node getNodeByUuid(Node node, String referencedCiUuid, Session session) throws RepositoryException {
        try {
            return session.getNodeByIdentifier(referencedCiUuid);
        }
        catch (ItemNotFoundException exc) {
            Node frozenNode;
            if (NodeUtils.nodeIsFrozen(node) && (frozenNode = NodeUtils.getFrozenNodeByUuid(referencedCiUuid, session)) != null) {
                return frozenNode;
            }
            throw exc;
        }
    }

    static Node getFrozenNodeByUuid(String uuid, Session session) throws RepositoryException {
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        ValueFactory valueFactory = session.getValueFactory();
        Query query = queryManager.createQuery("SELECT * FROM [{http://www.jcp.org/jcr/nt/1.0}frozenNode] WHERE [jcr:frozenUuid] = $uuid", "JCR-SQL2");
        query.bindValue("uuid", valueFactory.createValue(uuid));
        QueryResult result = query.execute();
        NodeIterator resultNodes = result.getNodes();
        if (resultNodes.hasNext()) {
            return resultNodes.nextNode();
        }
        return null;
    }

    static boolean nodeIsFrozen(Node node) throws RepositoryException {
        return node.isNodeType("{http://www.jcp.org/jcr/nt/1.0}frozenNode");
    }
}

