/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.deployment;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TypeCalculator {
    private static final Logger logger = LoggerFactory.getLogger(TypeCalculator.class);

    public Type findMostSpecificDeployedTypeForDeployableAndContainerTypes(Type deployableType, Type containerType) {
        List<Type> deployedTypesForDeployableAndContainer = this.findDeployedTypesForDeployableAndContainerTypes(deployableType, containerType);
        logger.debug("Found types {} for <{}, {}>", new Object[]{deployedTypesForDeployableAndContainer, deployableType, containerType});
        if (deployedTypesForDeployableAndContainer.isEmpty()) {
            return null;
        }
        if (deployedTypesForDeployableAndContainer.size() == 1) {
            return deployedTypesForDeployableAndContainer.get(0);
        }
        List<Type> copy = this.filterMostSpecific(deployedTypesForDeployableAndContainer);
        logger.debug("Result of filtering most specific: {}", copy);
        if (copy.size() == 1) {
            return copy.get(0);
        }
        throw new Checks.IncorrectArgumentException(String.format("Found %s for %s and %s, expected exactly 1. Before filtering we had: %s", copy, deployableType, containerType, deployedTypesForDeployableAndContainer), new Object[0]);
    }

    List<Type> filterMostSpecific(List<Type> deployedTypesForDeployableAndContainer) {
        ArrayList copy = Lists.newArrayList(deployedTypesForDeployableAndContainer);
        for (Type currentType : deployedTypesForDeployableAndContainer) {
            Descriptor currentDescriptor = DescriptorRegistry.getDescriptor((Type)currentType);
            Iterator copyIt = copy.iterator();
            while (copyIt.hasNext()) {
                Type comparedType = (Type)copyIt.next();
                Descriptor comparedDescriptor = DescriptorRegistry.getDescriptor((Type)comparedType);
                boolean deployableEquals = comparedDescriptor.getDeployableType().equals((Object)currentDescriptor.getDeployableType());
                boolean containerEquals = comparedDescriptor.getContainerType().equals((Object)currentDescriptor.getContainerType());
                boolean containerSupertype = comparedDescriptor.getContainerType().isSuperTypeOf(currentDescriptor.getContainerType());
                boolean deployableSupertype = comparedDescriptor.getDeployableType().isSuperTypeOf(currentDescriptor.getDeployableType());
                boolean isSupertype = comparedType.isSuperTypeOf(currentType);
                String currentTypeString = String.format("%s<%s, %s>", currentType, currentDescriptor.getDeployableType(), currentDescriptor.getContainerType());
                String comparedTypeString = String.format("%s<%s, %s>", comparedType, comparedDescriptor.getDeployableType(), comparedDescriptor.getContainerType());
                if (containerSupertype && deployableEquals) {
                    logger.debug("Filtering out [{}] because is has a container supertype wrt. [{}]", (Object)comparedTypeString, (Object)currentTypeString);
                    copyIt.remove();
                    continue;
                }
                if (deployableSupertype && containerEquals) {
                    logger.debug("Filtering out [{}] because is has a deployable supertype wrt. [{}]", (Object)comparedTypeString, (Object)currentTypeString);
                    copyIt.remove();
                    continue;
                }
                if (deployableSupertype && containerSupertype) {
                    logger.debug("Filtering out [{}] because is has a container and deployable supertype wrt. [{}]", (Object)comparedTypeString, (Object)currentTypeString);
                    copyIt.remove();
                    continue;
                }
                if (!isSupertype) continue;
                logger.debug("Filtering out [{}] because is a supertype of [{}]", (Object)comparedTypeString, (Object)currentTypeString);
                copyIt.remove();
            }
        }
        return copy;
    }

    public List<Type> findDeployedTypesForDeployableAndContainerTypes(Type deployableType, Type containerType) {
        Collection deployedTypes = DescriptorRegistry.getSubtypes((Type)Type.valueOf(Deployed.class));
        final Descriptor deployableDesc = DescriptorRegistry.getDescriptor((Type)deployableType);
        final Descriptor containerDesc = DescriptorRegistry.getDescriptor((Type)containerType);
        return Lists.newArrayList((Iterable)Collections2.filter((Collection)deployedTypes, (Predicate)new Predicate<Type>(){

            public boolean apply(Type input) {
                Descriptor deployedDesc = DescriptorRegistry.getDescriptor((Type)input);
                return !deployedDesc.isVirtual() && deployableDesc.isAssignableTo(deployedDesc.getDeployableType()) && containerDesc.isAssignableTo(deployedDesc.getContainerType());
            }
        }));
    }
}

