/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import java.util.HashSet;
import javax.jcr.ReferentialIntegrityException;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ISMLocking;
import org.apache.jackrabbit.core.state.ItemStateCacheFactory;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.SharedItemStateManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionItemStateManager
extends SharedItemStateManager {
    private static final Logger log = LoggerFactory.getLogger(VersionItemStateManager.class);
    private final PersistenceManager pMgr;

    public VersionItemStateManager(PersistenceManager persistMgr, NodeId rootNodeId, NodeTypeRegistry ntReg, ItemStateCacheFactory cacheFactory, ISMLocking locking) throws ItemStateException {
        super(persistMgr, rootNodeId, ntReg, false, cacheFactory, locking);
        this.pMgr = persistMgr;
    }

    public NodeReferences getNodeReferences(NodeId id) throws NoSuchItemStateException, ItemStateException {
        try {
            return this.pMgr.loadReferencesTo(id);
        }
        catch (NoSuchItemStateException noSuchItemStateException) {
            throw new NoSuchItemStateException(id.toString());
        }
    }

    public boolean hasNodeReferences(NodeId id) {
        try {
            if (this.pMgr.existsReferencesTo(id)) {
                return true;
            }
        }
        catch (ItemStateException itemStateException) {
            // empty catch block
        }
        return false;
    }

    public boolean setNodeReferences(ChangeLog references) {
        try {
            ChangeLog log = new ChangeLog();
            for (NodeReferences source : references.modifiedRefs()) {
                NodeReferences target = new NodeReferences(source.getTargetId());
                for (PropertyId id : source.getReferences()) {
                    if (this.hasNonVirtualItemState(id.getParentId())) continue;
                    target.addReference(id);
                }
                log.modified(target);
            }
            if (log.hasUpdates()) {
                this.pMgr.store(log);
            }
            return true;
        }
        catch (ItemStateException e) {
            log.error("Error while setting references: " + e.toString());
            return false;
        }
    }

    protected void checkReferentialIntegrity(ChangeLog changes) throws ReferentialIntegrityException, ItemStateException {
        HashSet<NodeId> remove = new HashSet<NodeId>();
        for (NodeReferences refs : changes.modifiedRefs()) {
            NodeId id;
            if (!refs.hasReferences() || changes.has(id = refs.getTargetId()) || this.hasNonVirtualItemState(id)) continue;
            remove.add(refs.getTargetId());
        }
        for (NodeId id : remove) {
            changes.removeReferencesEntry(id);
        }
    }
}

