/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.zip.GeneralPurposeBit;
import org.apache.commons.compress.archivers.zip.UnsupportedZipFeatureException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipEncoding;
import org.apache.commons.compress.archivers.zip.ZipEncodingHelper;
import org.apache.commons.compress.archivers.zip.ZipLong;
import org.apache.commons.compress.archivers.zip.ZipShort;
import org.apache.commons.compress.archivers.zip.ZipUtil;

public class ZipArchiveInputStream
extends ArchiveInputStream {
    private static final int SHORT = 2;
    private static final int WORD = 4;
    private final ZipEncoding zipEncoding;
    private final boolean useUnicodeExtraFields;
    private final InputStream in;
    private final Inflater inf = new Inflater(true);
    private final CRC32 crc = new CRC32();
    private final byte[] buf = new byte[512];
    private ZipArchiveEntry current = null;
    private boolean closed = false;
    private boolean hitCentralDirectory = false;
    private int offsetInBuffer = 0;
    private long readBytesOfEntry = 0L;
    private long bytesReadFromStream = 0L;
    private int lengthOfLastRead = 0;
    private boolean hasDataDescriptor = false;
    private ByteArrayInputStream lastStoredEntry = null;
    private boolean allowStoredEntriesWithDataDescriptor = false;
    private static final int LFH_LEN = 30;

    public ZipArchiveInputStream(InputStream inputStream) {
        this(inputStream, "UTF8", true);
    }

    public ZipArchiveInputStream(InputStream inputStream, String encoding, boolean useUnicodeExtraFields) {
        this(inputStream, encoding, useUnicodeExtraFields, false);
    }

    public ZipArchiveInputStream(InputStream inputStream, String encoding, boolean useUnicodeExtraFields, boolean allowStoredEntriesWithDataDescriptor) {
        this.zipEncoding = ZipEncodingHelper.getZipEncoding(encoding);
        this.useUnicodeExtraFields = useUnicodeExtraFields;
        this.in = new PushbackInputStream(inputStream, this.buf.length);
        this.allowStoredEntriesWithDataDescriptor = allowStoredEntriesWithDataDescriptor;
    }

    public ZipArchiveEntry getNextZipEntry() throws IOException {
        if (this.closed || this.hitCentralDirectory) {
            return null;
        }
        if (this.current != null) {
            this.closeEntry();
        }
        byte[] lfh = new byte[30];
        try {
            this.readFully(lfh);
        }
        catch (EOFException e) {
            return null;
        }
        ZipLong sig = new ZipLong(lfh);
        if (sig.equals(ZipLong.CFH_SIG)) {
            this.hitCentralDirectory = true;
            return null;
        }
        if (!sig.equals(ZipLong.LFH_SIG)) {
            return null;
        }
        int off = 4;
        this.current = new ZipArchiveEntry();
        int versionMadeBy = ZipShort.getValue(lfh, off);
        this.current.setPlatform(versionMadeBy >> 8 & 0xF);
        GeneralPurposeBit gpFlag = GeneralPurposeBit.parse(lfh, off += 2);
        boolean hasUTF8Flag = gpFlag.usesUTF8ForNames();
        ZipEncoding entryEncoding = hasUTF8Flag ? ZipEncodingHelper.UTF8_ZIP_ENCODING : this.zipEncoding;
        this.hasDataDescriptor = gpFlag.usesDataDescriptor();
        this.current.setGeneralPurposeBit(gpFlag);
        this.current.setMethod(ZipShort.getValue(lfh, off += 2));
        long time = ZipUtil.dosToJavaTime(ZipLong.getValue(lfh, off += 2));
        this.current.setTime(time);
        off += 4;
        if (!this.hasDataDescriptor) {
            this.current.setCrc(ZipLong.getValue(lfh, off));
            this.current.setCompressedSize(ZipLong.getValue(lfh, off += 4));
            this.current.setSize(ZipLong.getValue(lfh, off += 4));
            off += 4;
        } else {
            off += 12;
        }
        int fileNameLen = ZipShort.getValue(lfh, off);
        int extraLen = ZipShort.getValue(lfh, off += 2);
        off += 2;
        byte[] fileName = new byte[fileNameLen];
        this.readFully(fileName);
        this.current.setName(entryEncoding.decode(fileName), fileName);
        byte[] extraData = new byte[extraLen];
        this.readFully(extraData);
        this.current.setExtra(extraData);
        if (!hasUTF8Flag && this.useUnicodeExtraFields) {
            ZipUtil.setNameAndCommentFromExtraFields(this.current, fileName, null);
        }
        return this.current;
    }

    public ArchiveEntry getNextEntry() throws IOException {
        return this.getNextZipEntry();
    }

    public boolean canReadEntryData(ArchiveEntry ae) {
        if (ae instanceof ZipArchiveEntry) {
            ZipArchiveEntry ze = (ZipArchiveEntry)ae;
            return ZipUtil.canHandleEntryData(ze) && this.supportsDataDescriptorFor(ze);
        }
        return false;
    }

    public int read(byte[] buffer, int start, int length) throws IOException {
        if (this.closed) {
            throw new IOException("The stream is closed");
        }
        if (this.inf.finished() || this.current == null) {
            return -1;
        }
        if (start <= buffer.length && length >= 0 && start >= 0 && buffer.length - start >= length) {
            ZipUtil.checkRequestedFeatures(this.current);
            if (!this.supportsDataDescriptorFor(this.current)) {
                throw new UnsupportedZipFeatureException(UnsupportedZipFeatureException.Feature.DATA_DESCRIPTOR, this.current);
            }
            if (this.current.getMethod() == 0) {
                int toRead;
                if (this.hasDataDescriptor) {
                    if (this.lastStoredEntry == null) {
                        this.readStoredEntry();
                    }
                    return this.lastStoredEntry.read(buffer, start, length);
                }
                long csize = this.current.getSize();
                if (this.readBytesOfEntry >= csize) {
                    return -1;
                }
                if (this.offsetInBuffer >= this.lengthOfLastRead) {
                    this.offsetInBuffer = 0;
                    this.lengthOfLastRead = this.in.read(this.buf);
                    if (this.lengthOfLastRead == -1) {
                        return -1;
                    }
                    this.count(this.lengthOfLastRead);
                    this.bytesReadFromStream += (long)this.lengthOfLastRead;
                }
                int n = toRead = length > this.lengthOfLastRead ? this.lengthOfLastRead - this.offsetInBuffer : length;
                if (csize - this.readBytesOfEntry < (long)toRead) {
                    toRead = (int)(csize - this.readBytesOfEntry);
                }
                System.arraycopy(this.buf, this.offsetInBuffer, buffer, start, toRead);
                this.offsetInBuffer += toRead;
                this.readBytesOfEntry += (long)toRead;
                this.crc.update(buffer, start, toRead);
                return toRead;
            }
            if (this.inf.needsInput()) {
                this.fill();
                if (this.lengthOfLastRead > 0) {
                    this.bytesReadFromStream += (long)this.lengthOfLastRead;
                }
            }
            int read = 0;
            try {
                read = this.inf.inflate(buffer, start, length);
            }
            catch (DataFormatException e) {
                throw new ZipException(e.getMessage());
            }
            if (read == 0) {
                if (this.inf.finished()) {
                    return -1;
                }
                if (this.lengthOfLastRead == -1) {
                    throw new IOException("Truncated ZIP file");
                }
            }
            this.crc.update(buffer, start, read);
            return read;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.in.close();
        }
    }

    public long skip(long value) throws IOException {
        if (value >= 0L) {
            long skipped;
            int x;
            byte[] b = new byte[1024];
            for (skipped = 0L; skipped < value; skipped += (long)x) {
                long rem = value - skipped;
                x = this.read(b, 0, (int)((long)b.length > rem ? rem : (long)b.length));
                if (x != -1) continue;
                return skipped;
            }
            return skipped;
        }
        throw new IllegalArgumentException();
    }

    public static boolean matches(byte[] signature, int length) {
        if (length < ZipArchiveOutputStream.LFH_SIG.length) {
            return false;
        }
        return ZipArchiveInputStream.checksig(signature, ZipArchiveOutputStream.LFH_SIG) || ZipArchiveInputStream.checksig(signature, ZipArchiveOutputStream.EOCD_SIG);
    }

    private static boolean checksig(byte[] signature, byte[] expected) {
        for (int i = 0; i < expected.length; ++i) {
            if (signature[i] == expected[i]) continue;
            return false;
        }
        return true;
    }

    private void closeEntry() throws IOException {
        if (this.closed) {
            throw new IOException("The stream is closed");
        }
        if (this.current == null) {
            return;
        }
        if (this.bytesReadFromStream <= this.current.getCompressedSize() && !this.hasDataDescriptor) {
            long n;
            for (long remaining = this.current.getCompressedSize() - this.bytesReadFromStream; remaining > 0L; remaining -= n) {
                n = this.in.read(this.buf, 0, (int)Math.min((long)this.buf.length, remaining));
                if (n < 0L) {
                    throw new EOFException("Truncated ZIP entry: " + this.current.getName());
                }
                this.count(n);
            }
        } else {
            this.skip(Long.MAX_VALUE);
            long inB = this.current.getMethod() == 8 ? ZipUtil.adjustToLong(this.inf.getTotalIn()) : this.readBytesOfEntry;
            int diff = (int)(this.bytesReadFromStream - inB);
            if (diff > 0) {
                ((PushbackInputStream)this.in).unread(this.buf, this.lengthOfLastRead - diff, diff);
                this.pushedBackBytes(diff);
            }
        }
        if (this.lastStoredEntry == null && this.hasDataDescriptor) {
            this.readDataDescriptor();
        }
        this.inf.reset();
        this.bytesReadFromStream = 0L;
        this.readBytesOfEntry = 0L;
        this.lengthOfLastRead = 0;
        this.offsetInBuffer = 0;
        this.crc.reset();
        this.current = null;
        this.lastStoredEntry = null;
    }

    private void fill() throws IOException {
        if (this.closed) {
            throw new IOException("The stream is closed");
        }
        this.lengthOfLastRead = this.in.read(this.buf);
        if (this.lengthOfLastRead > 0) {
            this.count(this.lengthOfLastRead);
            this.inf.setInput(this.buf, 0, this.lengthOfLastRead);
        }
    }

    private void readFully(byte[] b) throws IOException {
        int x = 0;
        for (int count = 0; count != b.length; count += x) {
            x = this.in.read(b, count, b.length - count);
            if (x == -1) {
                throw new EOFException();
            }
            this.count(x);
        }
    }

    private void readDataDescriptor() throws IOException {
        byte[] b = new byte[4];
        this.readFully(b);
        ZipLong val = new ZipLong(b);
        if (ZipLong.DD_SIG.equals(val)) {
            this.readFully(b);
            val = new ZipLong(b);
        }
        this.current.setCrc(val.getValue());
        this.readFully(b);
        this.current.setCompressedSize(new ZipLong(b).getValue());
        this.readFully(b);
        this.current.setSize(new ZipLong(b).getValue());
    }

    private boolean supportsDataDescriptorFor(ZipArchiveEntry entry) {
        return this.allowStoredEntriesWithDataDescriptor || !entry.getGeneralPurposeBit().usesDataDescriptor() || entry.getMethod() == 8;
    }

    private void readStoredEntry() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] LFH = ZipLong.LFH_SIG.getBytes();
        byte[] CFH = ZipLong.CFH_SIG.getBytes();
        byte[] DD = ZipLong.DD_SIG.getBytes();
        int off = 0;
        boolean done = false;
        while (!done) {
            int r = this.in.read(this.buf, off, 512 - off);
            if (r <= 0) {
                throw new IOException("Truncated ZIP file");
            }
            if (r + off < 4) {
                off += r;
                continue;
            }
            int readTooMuch = 0;
            for (int i = 0; !done && i < r - 4; ++i) {
                if (this.buf[i] != LFH[0] || this.buf[i + 1] != LFH[1]) continue;
                if (this.buf[i + 2] == LFH[2] && this.buf[i + 3] == LFH[3] || this.buf[i] == CFH[2] && this.buf[i + 3] == CFH[3]) {
                    readTooMuch = off + r - i - 12;
                    done = true;
                } else if (this.buf[i + 2] == DD[2] && this.buf[i + 3] == DD[3]) {
                    readTooMuch = off + r - i;
                    done = true;
                }
                if (!done) continue;
                ((PushbackInputStream)this.in).unread(this.buf, off + r - readTooMuch, readTooMuch);
                bos.write(this.buf, 0, i);
                this.readDataDescriptor();
            }
            if (done) continue;
            if (off + r > 15) {
                bos.write(this.buf, 0, off + r - 15);
                System.arraycopy(this.buf, off + r - 15, this.buf, 0, 15);
                off = 15;
                continue;
            }
            off += r;
        }
        byte[] b = bos.toByteArray();
        this.lastStoredEntry = new ByteArrayInputStream(b);
    }
}

