/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.booter.local;

import com.google.common.base.Predicate;
import com.google.common.io.Closeables;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class SyntheticHelper {
    static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = SyntheticHelper.createDocumentBuilderFactory();
    private static final Logger logger = LoggerFactory.getLogger(SyntheticHelper.class);

    SyntheticHelper() {
    }

    private static DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory documentBuilderFactory;
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema syntheticSchema = schemaFactory.newSchema(Thread.currentThread().getContextClassLoader().getResource("synthetic.xsd"));
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setSchema(syntheticSchema);
        }
        catch (SAXException exc) {
            throw new RuntimeException("Cannot read schema synthetic.xsd", exc);
        }
        return documentBuilderFactory;
    }

    static Document readSyntheticDocument(final URL syntheticXML) throws IOException {
        InputStream syntheticXMLStream = syntheticXML.openStream();
        try {
            final boolean[] validationErrorsFound = new boolean[1];
            DocumentBuilder builder = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exc) throws SAXException {
                    logger.warn("Warning while parsing " + syntheticXML, (Throwable)exc);
                }

                @Override
                public void error(SAXParseException exc) throws SAXException {
                    logger.error("Error while parsing " + syntheticXML, (Throwable)exc);
                    validationErrorsFound[0] = true;
                }

                @Override
                public void fatalError(SAXParseException exc) throws SAXException {
                    logger.error("Fatal error while parsing " + syntheticXML, (Throwable)exc);
                    validationErrorsFound[0] = true;
                }
            });
            Document doc = builder.parse(syntheticXMLStream);
            if (validationErrorsFound[0]) {
                throw new RuntimeException("One or more errors were found while parsing " + syntheticXML);
            }
            Document document = doc;
            return document;
        }
        catch (RuntimeException exc) {
            throw new RuntimeException("Cannot read synthetic configuration " + syntheticXML, exc);
        }
        catch (ParserConfigurationException exc) {
            throw new RuntimeException("Cannot read synthetic configuration " + syntheticXML, exc);
        }
        catch (SAXException exc) {
            throw new RuntimeException("Cannot read synthetic configuration " + syntheticXML, exc);
        }
        finally {
            Closeables.closeQuietly((Closeable)syntheticXMLStream);
        }
    }

    static String getRequiredStringAttribute(Element element, String attributeName) {
        if (element.hasAttribute(attributeName)) {
            return element.getAttribute(attributeName);
        }
        throw new IllegalArgumentException("Attribute " + attributeName + " not provided");
    }

    static String getRequiredStringAttribute(Element element, String attributeName, String additionalMessage) {
        if (element.hasAttribute(attributeName)) {
            return element.getAttribute(attributeName);
        }
        throw new IllegalArgumentException("Attribute " + attributeName + " not provided " + additionalMessage);
    }

    static Type getRequiredTypeAttribute(Element element, String attributeName) {
        Type type = SyntheticHelper.getOptionalTypeAttribute(element, attributeName);
        if (type == null) {
            throw new IllegalArgumentException("Attribute " + attributeName + " not provided");
        }
        return type;
    }

    static Type getOptionalTypeAttribute(Element element, String attributeName, Type defaultValue) {
        String typeAttr = SyntheticHelper.getOptionalStringAttribute(element, attributeName, null);
        Type type = defaultValue;
        if (typeAttr != null) {
            type = Type.valueOf((String)typeAttr);
        }
        return type;
    }

    static Type getOptionalTypeAttribute(Element element, String attributeName) {
        return SyntheticHelper.getOptionalTypeAttribute(element, attributeName, null);
    }

    static boolean getOptionalBooleanAttribute(Element element, String attributeName, boolean defaultValue) {
        return Boolean.valueOf(SyntheticHelper.getOptionalStringAttribute(element, attributeName, Boolean.toString(defaultValue)));
    }

    static String getOptionalStringAttribute(Element element, String attributeName, String defaultValue) {
        if (element.hasAttribute(attributeName)) {
            return element.getAttribute(attributeName);
        }
        return defaultValue;
    }

    static Iterable<Element> childrenByName(final Element element, final Predicate<String> matcher) {
        return new Iterable<Element>(){

            @Override
            public Iterator<Element> iterator() {
                return SyntheticHelper.childByName(element, (Predicate<String>)matcher);
            }
        };
    }

    static Iterator<Element> childByName(final Element element, final Predicate<String> matcher) {
        return new Iterator<Element>(){
            private int i = 0;
            private NodeList childNodes = element.getChildNodes();
            private int nextIndex = 0;

            @Override
            public boolean hasNext() {
                if (this.nextIndex == this.i) {
                    this.nextIndex = this.findNext();
                }
                return this.nextIndex > this.i;
            }

            @Override
            public Element next() {
                if (this.nextIndex == this.i) {
                    this.nextIndex = this.findNext();
                }
                if (this.nextIndex < this.i) {
                    throw new NoSuchElementException("There are no more matching elements");
                }
                this.i = this.nextIndex;
                return (Element)this.childNodes.item(this.i);
            }

            private int findNext() {
                int next = this.i;
                while (next < this.childNodes.getLength()) {
                    Element e;
                    if (!(this.childNodes.item(++next) instanceof Element) || !matcher.apply((Object)(e = (Element)this.childNodes.item(next)).getNodeName())) continue;
                    return next;
                }
                return this.i - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static <E> void forEach(Iterator<E> iterator, Closure<E> closure) {
        while (iterator.hasNext()) {
            closure.call(iterator.next());
        }
    }

    public static interface Closure<E> {
        public void call(E var1);
    }
}

