/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core.upgrade;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.jcr.JcrUtils;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.deployit.upgrade.RawRepositoryImpl;
import com.xebialabs.deployit.util.Tuple;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.core.security.principal.EveryonePrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Deployit37Security
extends Upgrade {
    public static final Joiner PRINCIPAL_JOINER = Joiner.on((String)",").skipNulls();
    private static final EnumSet<Permission> RELATED_ACL_PERMISSIONS = EnumSet.of(Permission.DEPLOY_INITIAL, Permission.DEPLOY_UPGRADE, Permission.UNDEPLOY);
    private static final EnumSet<Permission> EX_GLOBAL_PERMISSIONS = EnumSet.of(Permission.READ, new Permission[]{Permission.IMPORT_INITIAL, Permission.IMPORT_UPGRADE, Permission.DEPLOY_INITIAL, Permission.DEPLOY_UPGRADE, Permission.UNDEPLOY, Permission.EDIT_REPO});
    private static final Function<Value, String> VALUE_TO_STRING = new Function<Value, String>(){

        public String apply(Value input) {
            try {
                return input.getString();
            }
            catch (RepositoryException e) {
                logger.error("Couldn't convert value to string", (Throwable)e);
                throw new UpgradeException("Couldn't convert value to string", new Object[0]);
            }
        }
    };
    private static final String GLOBAL = "<global>";
    private static final Splitter PATH_SPLITTER = Splitter.on((String)"/").omitEmptyStrings();
    private static final Joiner PATH_JOINER = Joiner.on((String)"/");
    private static final String DIRECTORY_PREFIX = "migration-dir-";
    private static final Logger logger = LoggerFactory.getLogger(Deployit37Security.class);

    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        logger.info("*** Running Deployit 3.7.0 Security Upgrade ***");
        Node securityNode = repository.read("/$configuration/security");
        try {
            Map<String, ListMultimap<Permission, String>> analyzedPermissionStructure = this.analyzePermissionStructure(securityNode);
            logger.info("This is the analyzed permission structure:");
            this.logPermissionStructure(analyzedPermissionStructure);
            this.removeNonExistingNodesFromAnalyzedStructure(analyzedPermissionStructure, repository);
            this.removeDeniesFromAnalyzedStructure(analyzedPermissionStructure, repository);
            Map<String, HashMultimap<Permission, String>> newPermissionStructure = this.filterDuplicateGrants(analyzedPermissionStructure);
            this.removeNonTopLevelPermissions(newPermissionStructure);
            this.fixinNonInheritanceInNewStructure(newPermissionStructure);
            Map<String, String> nodeToDirmapping = this.mapToDirectories(newPermissionStructure);
            this.remapPermissionStructure(newPermissionStructure, nodeToDirmapping);
            this.mapGlobalPermissionsToConfigurationItems(newPermissionStructure);
            this.addImportRemoveToApplications(newPermissionStructure);
            logger.info("This will be the new Permission Structure:");
            this.logPermissionStructure(newPermissionStructure);
            this.clearAllAcls(analyzedPermissionStructure, repository);
            this.createNewRepositoryStructure(nodeToDirmapping, repository);
            this.makeRootNodesVersionable(repository);
            Set<String> principals = this.gatherAllKnownPrincipals(newPermissionStructure);
            logger.info("Found the following principals known to Deployit: [{}]", principals);
            List<Role> roles = this.convertToRoles(principals);
            this.writeRoles(roles, repository);
            this.writeRoleAssignments(roles, repository);
            this.writeNewPermissions(newPermissionStructure, roles, repository, securityNode);
        }
        catch (RepositoryException e) {
            logger.error("Exception while upgrading security", (Throwable)e);
            throw new UpgradeException("Caught an exception while upgrading to 3.7 Security, please send the server log.", new Object[0]);
        }
        logger.info("*** Finished Upgrade ***");
        return true;
    }

    private void makeRootNodesVersionable(RawRepository repository) throws RepositoryException {
        for (Metadata.ConfigurationItemRoot root : EnumSet.complementOf(EnumSet.of(Metadata.ConfigurationItemRoot.NESTED))) {
            String absolutePathFromId = JcrPathHelper.getAbsolutePathFromId(root.getRootNodeName());
            if (!Deployit37Security.exists(repository, absolutePathFromId)) continue;
            Node node = repository.read(absolutePathFromId);
            node.addMixin("{http://www.jcp.org/jcr/mix/1.0}versionable");
        }
    }

    private void logPermissionStructure(Map<String, ? extends Multimap<Permission, String>> permissionStructure) {
        ArrayList nodes = Lists.newArrayList(permissionStructure.keySet());
        Collections.sort(nodes);
        StringBuilder b = new StringBuilder();
        for (String node : nodes) {
            b.append(String.format("On node [%s]:\n", node));
            for (Map.Entry pe : permissionStructure.get(node).asMap().entrySet()) {
                b.append(String.format("\t%s=%s\n", ((Permission)((Object)pe.getKey())).getPermissionName(), pe.getValue()));
            }
            b.append("\n");
        }
        logger.info("\n{}", (Object)b);
    }

    private Map<String, ListMultimap<Permission, String>> analyzePermissionStructure(Node securityNode) throws RepositoryException {
        logger.info("Analyzing the existing permission structure");
        final ConcurrentMap analysis = new MapMaker().makeComputingMap((Function)new Function<String, ListMultimap<Permission, String>>(){

            public ListMultimap<Permission, String> apply(String input) {
                return ArrayListMultimap.create();
            }
        });
        JcrUtils.forEachNonJcrProperty(securityNode, new JcrUtils.Callback<Property>(){

            @Override
            public void apply(Property input) throws RepositoryException {
                String user = input.getName();
                List permissionsGranted = Deployit37Security.transformValuesToPermissions(input);
                logger.debug("Found permissions [{}] granted to [{}]", (Object)permissionsGranted, (Object)user);
                for (Tuple permissionNodeTuple : permissionsGranted) {
                    String nodePath = (String)permissionNodeTuple.getB();
                    Permission permission = (Permission)((Object)permissionNodeTuple.getA());
                    String absolutePathFromId = nodePath.equals(Deployit37Security.GLOBAL) ? nodePath : JcrPathHelper.getAbsolutePathFromId(nodePath);
                    logger.debug("Adding to migration: permission [{}] on [{}] granted to [{}]", new Object[]{permission, absolutePathFromId, user});
                    ((ListMultimap)analysis.get(absolutePathFromId)).put((Object)permission, (Object)user);
                }
                input.remove();
            }
        });
        return analysis;
    }

    private void removeNonExistingNodesFromAnalyzedStructure(Map<String, ListMultimap<Permission, String>> analyzedPermissionStructure, RawRepository repository) {
        logger.info("Removing non-existing nodes from the analyzed permission structure");
        ArrayList toBeRemoved = Lists.newArrayList();
        for (String nodePath : analyzedPermissionStructure.keySet()) {
            boolean exists;
            if (nodePath.equals(GLOBAL)) continue;
            try {
                exists = repository.read(nodePath) != null;
            }
            catch (RuntimeException re) {
                exists = false;
            }
            if (exists) continue;
            toBeRemoved.add(nodePath);
        }
        for (String nodePath : toBeRemoved) {
            logger.info("Removing node [{}] with permissions [{}] from migration as it no longer exists.", (Object)nodePath, analyzedPermissionStructure.get(nodePath));
            analyzedPermissionStructure.remove(nodePath);
        }
    }

    private void removeDeniesFromAnalyzedStructure(Map<String, ListMultimap<Permission, String>> analyzedPermissionStructure, RawRepository repository) throws RepositoryException {
        logger.info("Cleaning denies from the analyzed permission structure");
        for (String node : analyzedPermissionStructure.keySet()) {
            AccessControlPolicy[] policies;
            ListMultimap<Permission, String> permissionToUserMap = analyzedPermissionStructure.get(node);
            if (!permissionToUserMap.containsKey((Object)Permission.READ)) {
                logger.debug("Node [{}] does not have any read permissions", (Object)node);
                continue;
            }
            AccessControlManager accessControlManager = Deployit37Security.getAccessControlManager(repository);
            String path = node;
            if (node.equals(GLOBAL)) {
                path = "/";
            }
            for (AccessControlPolicy policy : policies = accessControlManager.getPolicies(path)) {
                if (!(policy instanceof JackrabbitAccessControlList)) continue;
                JackrabbitAccessControlList acl = (JackrabbitAccessControlList)policy;
                for (AccessControlEntry ace : acl.getAccessControlEntries()) {
                    if (!(ace instanceof JackrabbitAccessControlEntry)) continue;
                    boolean allowed = ((JackrabbitAccessControlEntry)ace).isAllow();
                    Privilege[] privileges = ace.getPrivileges();
                    if (allowed || privileges.length != 1 || !privileges[0].getName().equals("jcr:read")) continue;
                    Principal principal = ace.getPrincipal();
                    permissionToUserMap.get((Object)Permission.READ).remove(principal.getName());
                    logger.warn("Not migrating denied READ permission granted to [{}] on [{}]", (Object)principal.getName(), (Object)node);
                }
            }
        }
    }

    private Map<String, HashMultimap<Permission, String>> filterDuplicateGrants(Map<String, ListMultimap<Permission, String>> analyzedPermissionStructure) {
        logger.info("Filtering duplicate principals from grants");
        HashMap filtered = Maps.newHashMap();
        for (Map.Entry<String, ListMultimap<Permission, String>> e : analyzedPermissionStructure.entrySet()) {
            filtered.put(e.getKey(), HashMultimap.create((Multimap)((Multimap)e.getValue())));
        }
        return filtered;
    }

    private void removeNonTopLevelPermissions(Map<String, HashMultimap<Permission, String>> newPermissionStructure) {
        logger.info("Removing all permissions not granted to the first 2 levels of the repository.");
        HashSet deepNodes = Sets.newHashSet((Iterable)Sets.filter(newPermissionStructure.keySet(), (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return Iterables.size((Iterable)PATH_SPLITTER.split((CharSequence)input)) > 2;
            }
        }));
        for (String deepNode : deepNodes) {
            HashMultimap<Permission, String> permissions = newPermissionStructure.get(deepNode);
            logger.warn("Not migrating permissions on node [{}] ({})", (Object)deepNode, permissions);
            newPermissionStructure.remove(deepNode);
        }
    }

    private void fixinNonInheritanceInNewStructure(Map<String, HashMultimap<Permission, String>> newPermissionStructure) {
        logger.info("Consolidating the new permission structure");
        ArrayList nodes = Lists.newArrayList(newPermissionStructure.keySet());
        Collections.sort(nodes);
        logger.debug("Sorted the nodes in parent->child order: {}", (Object)nodes);
        Stack<String> previousNodes = new Stack<String>();
        for (String node : nodes) {
            while (!previousNodes.isEmpty()) {
                String previousNode = (String)previousNodes.peek();
                if (node.startsWith(previousNode)) {
                    logger.debug("Copying read/repo#edit permissions from [{}] to [{}]", (Object)previousNode, (Object)node);
                    Multimap parentPermissions = (Multimap)newPermissionStructure.get(previousNode);
                    Multimap myPermissions = (Multimap)newPermissionStructure.get(node);
                    Deployit37Security.copyPermissions((Multimap<Permission, String>)parentPermissions, (Multimap<Permission, String>)myPermissions, Permission.READ);
                    Deployit37Security.copyPermissions((Multimap<Permission, String>)parentPermissions, (Multimap<Permission, String>)myPermissions, Permission.EDIT_REPO);
                    break;
                }
                previousNodes.pop();
            }
            previousNodes.push(node);
        }
    }

    private Map<String, String> mapToDirectories(Map<String, HashMultimap<Permission, String>> newPermissionStructure) {
        logger.info("Separating permission structure to groups");
        Map onlySubNodePermissions = Maps.filterKeys(newPermissionStructure, (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return input.indexOf("/", 1) > -1;
            }
        });
        ImmutableListMultimap lookupRootToNode = Multimaps.index(onlySubNodePermissions.keySet(), (Function)new Function<String, String>(){

            public String apply(String input) {
                return (String)PATH_SPLITTER.split((CharSequence)input).iterator().next();
            }
        });
        logger.trace("Indexed nodes from permission structure to roots: {}", (Object)lookupRootToNode);
        logger.debug("Building mapping from permissions -> directories");
        HashMap lookupPermissionToDirectoryMap = Maps.newHashMap();
        int groupNr = 1;
        HashSet uniqueSubNodeOnlyPermissions = Sets.newHashSet(onlySubNodePermissions.values());
        for (HashMultimap permissions : uniqueSubNodeOnlyPermissions) {
            lookupPermissionToDirectoryMap.put(permissions, DIRECTORY_PREFIX + groupNr++);
        }
        logger.trace("Permission -> directory: {}", (Object)lookupPermissionToDirectoryMap);
        HashMap nodeToGroup = Maps.newHashMap();
        for (Map.Entry e : lookupRootToNode.asMap().entrySet()) {
            String rootId = JcrPathHelper.getAbsolutePathFromId((String)e.getKey());
            Collection nodesInRoot = (Collection)e.getValue();
            for (String node : nodesInRoot) {
                HashMultimap permissions = (HashMultimap)onlySubNodePermissions.get(node);
                String dirName = (String)lookupPermissionToDirectoryMap.get(permissions);
                if (dirName == null) continue;
                nodeToGroup.put(node, PATH_JOINER.join((Object)rootId, (Object)dirName, new Object[0]));
            }
        }
        logger.debug("Mapped nodes to directories: {}", (Object)nodeToGroup);
        return nodeToGroup;
    }

    private void remapPermissionStructure(Map<String, HashMultimap<Permission, String>> newPermissionStructure, Map<String, String> groupMapping) {
        logger.info("Remapping the permission structure to groups.");
        for (String node : Sets.newHashSet(newPermissionStructure.keySet())) {
            String group = groupMapping.get(node);
            if (group == null) continue;
            HashMultimap<Permission, String> permissions = newPermissionStructure.get(node);
            newPermissionStructure.remove(node);
            newPermissionStructure.put(group, permissions);
        }
    }

    private void mapGlobalPermissionsToConfigurationItems(Map<String, HashMultimap<Permission, String>> newPermissionStructure) {
        logger.info("Mapping old global permissions to configuration items.");
        HashMultimap permissionPrincipals = newPermissionStructure.get(GLOBAL);
        if (permissionPrincipals == null) {
            permissionPrincipals = HashMultimap.create();
        }
        Set nodes = Sets.filter(newPermissionStructure.keySet(), (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return !input.equals(Deployit37Security.GLOBAL);
            }
        });
        for (Permission permission : EX_GLOBAL_PERMISSIONS) {
            if (permissionPrincipals.containsKey((Object)permission)) {
                for (String node : nodes) {
                    if (!permission.isApplicableTo(JcrPathHelper.getIdFromAbsolutePath(node))) continue;
                    newPermissionStructure.get(node).putAll((Object)permission, (Iterable)permissionPrincipals.get((Object)permission));
                }
            }
            permissionPrincipals.removeAll((Object)permission);
        }
    }

    private void addImportRemoveToApplications(Map<String, HashMultimap<Permission, String>> newPermissionStructure) {
        logger.info("Adding import#remove to Applications with repo#edit");
        Set applications = Sets.filter(newPermissionStructure.entrySet(), (Predicate)new Predicate<Map.Entry<String, HashMultimap<Permission, String>>>(){

            public boolean apply(Map.Entry<String, HashMultimap<Permission, String>> input) {
                boolean isApp = JcrPathHelper.getIdFromAbsolutePath(input.getKey()).startsWith(Metadata.ConfigurationItemRoot.APPLICATIONS.getRootNodeName());
                boolean hasEditRepo = input.getValue().containsKey((Object)Permission.EDIT_REPO);
                return isApp && hasEditRepo;
            }
        });
        for (Map.Entry app : applications) {
            HashSet principals = Sets.newHashSet((Iterable)((HashMultimap)app.getValue()).get((Object)Permission.EDIT_REPO));
            logger.debug("Add import#remove to [{}] for principals [{}]", app.getKey(), (Object)principals);
            ((HashMultimap)app.getValue()).putAll((Object)Permission.IMPORT_REMOVE, (Iterable)principals);
        }
    }

    private void clearAllAcls(Map<String, ListMultimap<Permission, String>> analyzedPermissionStructure, RawRepository repository) throws RepositoryException {
        logger.info("Clearing out old permissions!");
        for (Map.Entry<String, ListMultimap<Permission, String>> e : analyzedPermissionStructure.entrySet()) {
            String absoluteNodePath = e.getKey();
            ListMultimap<Permission, String> permissionToUser = e.getValue();
            if (absoluteNodePath.equals(GLOBAL)) continue;
            this.clearNodeAcl(repository, absoluteNodePath, permissionToUser);
        }
        Deployit37Security.clearRoots(repository);
        Deployit37Security.clearAcl("/tasks", Deployit37Security.getAccessControlManager(repository));
        Deployit37Security.clearAcl("/$configuration", Deployit37Security.getAccessControlManager(repository));
        Deployit37Security.clearRepositoryRoot(repository);
    }

    private void clearNodeAcl(RawRepository repository, String absoluteNodePath, ListMultimap<Permission, String> permissionToUser) throws RepositoryException {
        Deployit37Security.clearAcl(absoluteNodePath, Deployit37Security.getAccessControlManager(repository));
        for (Permission permission : permissionToUser.keySet()) {
            if (!Deployit37Security.hasRelatedAcls(permission)) continue;
            this.clearRelatedAcls(absoluteNodePath, repository);
        }
    }

    private void clearRelatedAcls(String absoluteAffectedNodePath, RawRepository repository) throws RepositoryException {
        logger.info("Clearing related ACL from [{}]", (Object)absoluteAffectedNodePath);
        Preconditions.checkArgument((boolean)absoluteAffectedNodePath.contains(Metadata.ConfigurationItemRoot.ENVIRONMENTS.getRootNodeName()), (String)"Only environments have a related ACL (%s)", (Object[])new Object[]{absoluteAffectedNodePath});
        Node read = repository.read(absoluteAffectedNodePath);
        List members = Lists.newArrayList();
        List dictionaries = Lists.newArrayList();
        if (read.hasProperty("members")) {
            members = Lists.transform((List)Lists.newArrayList((Object[])read.getProperty("members").getValues()), VALUE_TO_STRING);
        }
        if (read.hasProperty("dictionaries")) {
            dictionaries = Lists.transform((List)Lists.newArrayList((Object[])read.getProperty("dictionaries").getValues()), VALUE_TO_STRING);
        }
        for (String memberUuid : members) {
            String member = ((RawRepositoryImpl)repository).getSession().getNodeByIdentifier(memberUuid).getPath();
            logger.debug("Clearing ACL from member [{}] of environment [{}]", (Object)member, (Object)absoluteAffectedNodePath);
            Deployit37Security.clearAcl(member, Deployit37Security.getAccessControlManager(repository));
        }
        for (String dictUuid : dictionaries) {
            String dict = ((RawRepositoryImpl)repository).getSession().getNodeByIdentifier(dictUuid).getPath();
            logger.debug("Clearing ACL from dictionary [{}] of environment [{}]", (Object)dict, (Object)absoluteAffectedNodePath);
            Deployit37Security.clearAcl(dict, Deployit37Security.getAccessControlManager(repository));
        }
    }

    private void createNewRepositoryStructure(Map<String, String> nodeToDirMapping, RawRepository repository) throws RepositoryException {
        Object node;
        logger.info("Creating the new Repository structure.");
        String directoryType = Type.valueOf(Directory.class).toString();
        for (String string : Sets.newHashSet(nodeToDirMapping.values())) {
            node = repository.create(string);
            if (node.getIndex() != 1) {
                node.remove();
                throw new IllegalStateException("The impossible has happened, you already have a node called [" + string + "] in your repository. Please contact deployit-support@xebialabs.com");
            }
            node.addMixin("deployit:configurationItem");
            node.addMixin("{http://www.jcp.org/jcr/mix/1.0}referenceable");
            node.addMixin("{http://www.jcp.org/jcr/mix/1.0}versionable");
            node.setProperty("$configuration.item.type", directoryType);
            logger.debug("Created a [{}] at [{}]", (Object)directoryType, (Object)string);
        }
        for (Map.Entry entry : nodeToDirMapping.entrySet()) {
            node = (String)entry.getKey();
            String dir = (String)entry.getValue();
            String newLocation = PATH_JOINER.join((Object)dir, Iterables.getLast((Iterable)PATH_SPLITTER.split((CharSequence)node)), new Object[0]);
            logger.debug("Moving [{}] to new location [{}]", node, (Object)newLocation);
            ((RawRepositoryImpl)repository).getSession().move((String)node, newLocation);
        }
    }

    private void writeNewPermissions(Map<String, HashMultimap<Permission, String>> newPermissionStructure, List<Role> roles, RawRepository repository, Node securityNode) throws RepositoryException {
        logger.info("Writing the new permissions!");
        for (Map.Entry<String, HashMultimap<Permission, String>> nodePermission : newPermissionStructure.entrySet()) {
            if (nodePermission.getKey().equals(GLOBAL)) {
                logger.info("Writing global permissions.");
                this.writeNewPermissions(nodePermission.getValue(), roles, securityNode);
                continue;
            }
            this.writeNewNodePermissions(nodePermission.getKey(), nodePermission.getValue(), roles, repository);
        }
    }

    private void writeNewNodePermissions(String absoluteNodePath, HashMultimap<Permission, String> permissionToUser, List<Role> roles, RawRepository repository) throws RepositoryException {
        logger.info("Writing new permissions for node [{}]", (Object)absoluteNodePath);
        Node read = repository.read(absoluteNodePath);
        this.writeNewPermissions(permissionToUser, roles, read);
    }

    private void writeNewPermissions(HashMultimap<Permission, String> permissionToUser, List<Role> roles, Node securityNode) throws RepositoryException {
        final ImmutableMap roleLookup = Maps.uniqueIndex(roles, (Function)new Function<Role, String>(){

            public String apply(Role input) {
                return input.getName();
            }
        });
        HashMap toWrite = Maps.newHashMap();
        for (Map.Entry entry : permissionToUser.asMap().entrySet()) {
            toWrite.put(((Permission)((Object)entry.getKey())).getPermissionName(), PRINCIPAL_JOINER.join(Iterables.transform((Iterable)((Iterable)entry.getValue()), (Function)new Function<String, Integer>(){

                public Integer apply(String input) {
                    Role role = (Role)roleLookup.get((Object)input);
                    return role.getId();
                }
            })));
        }
        JcrUtils.writeMap(securityNode, "securityPermissions", toWrite);
    }

    private void writeRoleAssignments(List<Role> roles, RawRepository repository) throws RepositoryException {
        logger.info("Writing initial role assignments");
        Node node = repository.create("/$configuration/roleAssignments");
        for (Role role : roles) {
            node.setProperty(role.getName(), role.getId().toString());
        }
    }

    private List<Role> convertToRoles(Set<String> principals) {
        logger.info("Converting all principals to roles");
        final AtomicInteger counter = new AtomicInteger(1);
        return Lists.newArrayList((Iterable)Iterables.transform(principals, (Function)new Function<String, Role>(){

            public Role apply(String input) {
                Role role = new Role(counter.getAndIncrement(), input);
                logger.debug("Giving principal [{}] role id [{}]", (Object)input, (Object)role.getId());
                return role;
            }
        }));
    }

    private void writeRoles(List<Role> roles, RawRepository repository) throws RepositoryException {
        logger.info("Writing new Roles");
        Node roleNode = repository.create("/$configuration/roles");
        for (Role role : roles) {
            roleNode.setProperty(role.getId().toString(), role.getName());
        }
    }

    private Set<String> gatherAllKnownPrincipals(Map<String, HashMultimap<Permission, String>> newPermissionStructure) throws RepositoryException {
        logger.info("Extracting all known principals");
        HashSet principals = Sets.newHashSet();
        for (Map.Entry<String, HashMultimap<Permission, String>> entry : newPermissionStructure.entrySet()) {
            logger.info("Extracting known principals from [{}]", (Object)entry.getKey());
            HashMultimap<Permission, String> value = entry.getValue();
            Collection ccprincipals = value.asMap().values();
            for (Collection cprincipals : ccprincipals) {
                principals.addAll(cprincipals);
            }
        }
        return principals;
    }

    public Version upgradeVersion() {
        return Version.valueOf((String)"deployit", (String)"3.7.0");
    }

    private static boolean hasRelatedAcls(Permission permission) {
        return RELATED_ACL_PERMISSIONS.contains((Object)permission);
    }

    private static List<Tuple<Permission, String>> transformValuesToPermissions(Property property) throws RepositoryException {
        Object[] values = property.getValues();
        return Lists.transform((List)Lists.newArrayList((Object[])values), (Function)new Function<Value, Tuple<Permission, String>>(){

            public Tuple<Permission, String> apply(Value input) {
                try {
                    return Deployit37Security.decodePermissionString(input.getString());
                }
                catch (RepositoryException e) {
                    logger.error("Exception while migrating security: ", (Throwable)e);
                    throw new UpgradeException("Please read the server log to see what went wrong with migration of security.", new Object[0]);
                }
            }
        });
    }

    private static Tuple<Permission, String> decodePermissionString(String permissionString) {
        for (Permission permission : Permission.values()) {
            if (!permissionString.startsWith(permission.getPermissionName())) continue;
            return Deployit37Security.decodePermissionString(permissionString, permission);
        }
        throw new RuntimeException("PermissionString " + permissionString + " could not be decoded");
    }

    private static Tuple<Permission, String> decodePermissionString(String permissionString, Permission permission) {
        int permissionNameCiSeparatorIndex = permission.getPermissionName().length() + 1;
        if (permissionNameCiSeparatorIndex >= permissionString.length()) {
            return new Tuple<Permission, String>(permission, GLOBAL);
        }
        String ciName = permissionString.substring(permissionNameCiSeparatorIndex).replace("$", "/");
        return new Tuple<Permission, String>(permission, ciName);
    }

    private static void copyPermissions(Multimap<Permission, String> parentPermissions, Multimap<Permission, String> myPermissions, Permission p) {
        if (parentPermissions.containsKey((Object)p)) {
            myPermissions.putAll((Object)p, (Iterable)parentPermissions.get((Object)p));
        }
    }

    private static AccessControlManager getAccessControlManager(RawRepository repository) throws RepositoryException {
        Session session = ((RawRepositoryImpl)repository).getSession();
        return session.getAccessControlManager();
    }

    private static void clearAcl(String absoluteAffectedNodePath, AccessControlManager accessControlManager) throws RepositoryException {
        AccessControlPolicy[] policies;
        logger.info("Clearing ACL from [{}]", (Object)absoluteAffectedNodePath);
        for (AccessControlPolicy policy : policies = accessControlManager.getPolicies(absoluteAffectedNodePath)) {
            if (!(policy instanceof JackrabbitAccessControlList)) continue;
            JackrabbitAccessControlList acl = (JackrabbitAccessControlList)policy;
            for (AccessControlEntry ace : acl.getAccessControlEntries()) {
                acl.removeAccessControlEntry(ace);
            }
            accessControlManager.setPolicy(absoluteAffectedNodePath, policy);
        }
    }

    private static void clearRoots(RawRepository repository) throws RepositoryException {
        logger.info("Clearing ACL on Root nodes.");
        for (Metadata.ConfigurationItemRoot root : EnumSet.complementOf(EnumSet.of(Metadata.ConfigurationItemRoot.NESTED))) {
            String rootPath = JcrPathHelper.getAbsolutePathFromId(root.getRootNodeName());
            if (!Deployit37Security.exists(repository, rootPath)) continue;
            Deployit37Security.clearAcl(rootPath, Deployit37Security.getAccessControlManager(repository));
        }
    }

    private static boolean exists(RawRepository repository, String rootPath) throws RepositoryException {
        return ((RawRepositoryImpl)repository).getSession().nodeExists(rootPath);
    }

    private static void clearRepositoryRoot(RawRepository repository) throws RepositoryException {
        logger.info("Clearing the repository root...");
        Deployit37Security.clearAcl("/", Deployit37Security.getAccessControlManager(repository));
        Deployit37Security.grantEveryoneReadAccess("/", Deployit37Security.getAccessControlManager(repository));
    }

    private static void grantEveryoneReadAccess(String absPath, AccessControlManager accessControlManager) throws RepositoryException {
        for (AccessControlPolicy policy : accessControlManager.getPolicies(absPath)) {
            if (!(policy instanceof JackrabbitAccessControlList)) continue;
            JackrabbitAccessControlList acl = (JackrabbitAccessControlList)policy;
            Privilege privilege = accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}read");
            acl.addAccessControlEntry((Principal)EveryonePrincipal.getInstance(), new Privilege[]{privilege});
            accessControlManager.setPolicy("/", policy);
        }
    }
}

