/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.replacement;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.core.MapStringStringView;
import com.xebialabs.deployit.core.StringValue;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.Dictionary;
import com.xebialabs.deployit.service.replacement.DictionaryValueException;
import com.xebialabs.deployit.service.replacement.MustachePlaceholderReplacer;
import com.xebialabs.deployit.service.replacement.PlaceholderExpander;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConsolidatedDictionary {
    private MapStringStringView entries = new MapStringStringView();

    public static ConsolidatedDictionary create(Collection<Dictionary> dicts) {
        ConsolidatedDictionary dictionary = new ConsolidatedDictionary();
        if (dicts != null) {
            for (Dictionary dict : dicts) {
                dictionary.addDictionary(dict);
            }
        }
        dictionary.entries = PlaceholderExpander.expand(dictionary.entries);
        return dictionary;
    }

    private void addDictionary(Dictionary d) {
        Map dictEntries = d.getEntries();
        if (dictEntries instanceof MapStringStringView) {
            Map<String, StringValue> wrapped = ((MapStringStringView)dictEntries).getWrapped();
            for (Map.Entry<String, StringValue> e : wrapped.entrySet()) {
                if (this.entries.containsKey(e.getKey())) continue;
                this.entries.getWrapped().put(e.getKey(), e.getValue());
            }
        } else {
            for (String k : dictEntries.keySet()) {
                if (this.entries.containsKey(k)) continue;
                this.entries.put(k, (String)dictEntries.get(k));
            }
        }
    }

    public Map<String, String> getEntries() {
        return this.entries;
    }

    public boolean containsKey(String key) {
        return this.entries.containsKey(key);
    }

    public String get(String key) {
        return this.entries.get(key);
    }

    public StringValue resolveScannedPlaceholder(String filePlaceholder) {
        return this.entries.getWrapped().get(filePlaceholder);
    }

    public Object resolve(Object value, PropertyDescriptor deployablePropDesc) throws DictionaryValueException {
        if (value == null) {
            return null;
        }
        MustachePlaceholderReplacer placeholderReplacer = new MustachePlaceholderReplacer(this.entries.getWrapped(), false);
        switch (deployablePropDesc.getKind()) {
            case BOOLEAN: 
            case INTEGER: 
            case SET_OF_CI: 
            case LIST_OF_CI: 
            case CI: 
            case ENUM: {
                return value;
            }
            case STRING: {
                return placeholderReplacer.replace((String)value);
            }
            case SET_OF_STRING: {
                return Sets.newHashSet(this.resolveCollection((Set)value, placeholderReplacer));
            }
            case LIST_OF_STRING: {
                return Lists.newArrayList(this.resolveCollection((List)value, placeholderReplacer));
            }
            case MAP_STRING_STRING: {
                return this.resolveMap((Map)value, placeholderReplacer);
            }
        }
        throw new IllegalStateException("Unknown property kind: " + deployablePropDesc.getKind());
    }

    private Object resolveMap(Map<String, String> value, MustachePlaceholderReplacer placeholderReplacer) {
        HashMap resolvedMap = Maps.newHashMap();
        for (Map.Entry<String, String> entry : value.entrySet()) {
            try {
                resolvedMap.put(entry.getKey(), placeholderReplacer.replace(entry.getValue()).toString());
            }
            catch (DictionaryValueException e) {
                resolvedMap.put(entry.getKey(), entry.getValue());
            }
        }
        return resolvedMap;
    }

    private Collection<String> resolveCollection(Collection<String> value, MustachePlaceholderReplacer placeholderReplacer) {
        ArrayList resolved = Lists.newArrayList();
        for (String s : value) {
            try {
                resolved.add(placeholderReplacer.replace(s).toString());
            }
            catch (DictionaryValueException e) {
                resolved.add(s);
            }
        }
        return resolved;
    }
}

