/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.overthere;

import com.xebialabs.overthere.OverthereProcessOutputHandler;
import java.io.Closeable;
import java.util.Timer;
import java.util.TimerTask;

public abstract class AutoFlushingProcessOutputHandler
implements OverthereProcessOutputHandler,
Closeable {
    public static final int FLUSH_DELAY_MS = 5000;
    public static final int FLUSH_CHECK_INTERVAL_MS = 2000;
    private static final Timer flushTimer = new Timer("AutoFlushTimer", true);
    private StringBuilder lineBuffer = new StringBuilder();
    private long flushAfter = AutoFlushingProcessOutputHandler.nextFlushTime();
    private TimerTask flushTimerTask = new TimerTask(){

        @Override
        public void run() {
            AutoFlushingProcessOutputHandler.this.checkFlushNeeded();
        }
    };

    public AutoFlushingProcessOutputHandler() {
        flushTimer.schedule(this.flushTimerTask, 5000L, 2000L);
    }

    public final void handleOutputLine(String line) {
    }

    public final void handleOutput(char c) {
        if (c != '\r' && c != '\n') {
            this.appendToLineBuffer(c);
        }
        if (c == '\n') {
            this.flushLineBuffer();
        }
    }

    private synchronized void appendToLineBuffer(char c) {
        this.lineBuffer.append(c);
    }

    private synchronized void checkFlushNeeded() {
        if (this.flushAfter < System.currentTimeMillis()) {
            this.flushLineBuffer();
        }
    }

    private synchronized void flushLineBuffer() {
        if (this.lineBuffer.length() > 0) {
            this.handleOutput(this.lineBuffer.toString());
            this.lineBuffer.setLength(0);
        }
        this.flushAfter = AutoFlushingProcessOutputHandler.nextFlushTime();
    }

    protected abstract void handleOutput(String var1);

    private static long nextFlushTime() {
        return System.currentTimeMillis() + 5000L;
    }

    @Override
    public synchronized void close() {
        this.flushTimerTask.cancel();
    }
}

