/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.sftp;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.OpenMode;
import net.schmizz.sshj.sftp.RemoteDirectory;
import net.schmizz.sshj.sftp.RemoteFile;
import net.schmizz.sshj.sftp.RemoteResourceFilter;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.sftp.SFTPEngine;
import net.schmizz.sshj.sftp.SFTPException;
import net.schmizz.sshj.xfer.LocalDestFile;
import net.schmizz.sshj.xfer.LocalSourceFile;

public class StatefulSFTPClient
extends SFTPClient {
    private String cwd = this.getSFTPEngine().canonicalize(".");

    public StatefulSFTPClient(SFTPEngine engine) throws IOException {
        super(engine);
        this.log.debug("Start dir = {}", (Object)this.cwd);
    }

    private synchronized String cwdify(String path) {
        return this.engine.getPathHelper().adjustForParent(this.cwd, path);
    }

    public synchronized void cd(String dirname) throws IOException {
        this.cwd = this.cwdify(dirname);
        if (this.statExistence(this.cwd) == null) {
            throw new SFTPException(this.cwd + ": does not exist");
        }
        this.log.debug("CWD = {}", (Object)this.cwd);
    }

    public synchronized List<RemoteResourceInfo> ls() throws IOException {
        return this.ls(this.cwd, null);
    }

    public synchronized List<RemoteResourceInfo> ls(RemoteResourceFilter filter) throws IOException {
        return this.ls(this.cwd, filter);
    }

    public synchronized String pwd() throws IOException {
        return super.canonicalize(this.cwd);
    }

    @Override
    public List<RemoteResourceInfo> ls(String path) throws IOException {
        return this.ls(path, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RemoteResourceInfo> ls(String path, RemoteResourceFilter filter) throws IOException {
        RemoteDirectory dir = this.getSFTPEngine().openDir(this.cwdify(path));
        try {
            List<RemoteResourceInfo> list = dir.scan(filter);
            return list;
        }
        finally {
            dir.close();
        }
    }

    @Override
    public RemoteFile open(String filename, Set<OpenMode> mode, FileAttributes attrs) throws IOException {
        return super.open(this.cwdify(filename), mode, attrs);
    }

    @Override
    public RemoteFile open(String filename, Set<OpenMode> mode) throws IOException {
        return super.open(this.cwdify(filename), mode);
    }

    @Override
    public RemoteFile open(String filename) throws IOException {
        return super.open(this.cwdify(filename));
    }

    @Override
    public void mkdir(String dirname) throws IOException {
        super.mkdir(this.cwdify(dirname));
    }

    @Override
    public void mkdirs(String path) throws IOException {
        super.mkdirs(this.cwdify(path));
    }

    @Override
    public FileAttributes statExistence(String path) throws IOException {
        return super.statExistence(this.cwdify(path));
    }

    @Override
    public void rename(String oldpath, String newpath) throws IOException {
        super.rename(this.cwdify(oldpath), this.cwdify(newpath));
    }

    @Override
    public void rm(String filename) throws IOException {
        super.rm(this.cwdify(filename));
    }

    @Override
    public void rmdir(String dirname) throws IOException {
        super.rmdir(this.cwdify(dirname));
    }

    @Override
    public void symlink(String linkpath, String targetpath) throws IOException {
        super.symlink(this.cwdify(linkpath), this.cwdify(targetpath));
    }

    @Override
    public void setattr(String path, FileAttributes attrs) throws IOException {
        super.setattr(this.cwdify(path), attrs);
    }

    @Override
    public String readlink(String path) throws IOException {
        return super.readlink(this.cwdify(path));
    }

    @Override
    public FileAttributes stat(String path) throws IOException {
        return super.stat(this.cwdify(path));
    }

    @Override
    public FileAttributes lstat(String path) throws IOException {
        return super.lstat(this.cwdify(path));
    }

    @Override
    public void truncate(String path, long size) throws IOException {
        super.truncate(this.cwdify(path), size);
    }

    @Override
    public String canonicalize(String path) throws IOException {
        return super.canonicalize(this.cwdify(path));
    }

    @Override
    public void get(String source, String dest) throws IOException {
        super.get(this.cwdify(source), dest);
    }

    @Override
    public void get(String source, LocalDestFile dest) throws IOException {
        super.get(this.cwdify(source), dest);
    }

    @Override
    public void put(String source, String dest) throws IOException {
        super.put(source, this.cwdify(dest));
    }

    @Override
    public void put(LocalSourceFile source, String dest) throws IOException {
        super.put(source, this.cwdify(dest));
    }
}

