/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.fs.FsCompositeDriver;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsMountPoint;
import de.schlichtherle.truezip.fs.FsSyncException;
import de.schlichtherle.truezip.fs.FsSyncExceptionBuilder;
import de.schlichtherle.truezip.fs.FsSyncOption;
import de.schlichtherle.truezip.fs.FsSyncOptions;
import de.schlichtherle.truezip.util.BitField;
import de.schlichtherle.truezip.util.ExceptionHandler;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Iterator;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
@DefaultAnnotation(value={NonNull.class})
public abstract class FsManager
implements Iterable<FsController<?>> {
    public static final BitField<FsSyncOption> UMOUNT = FsSyncOptions.UMOUNT;

    public abstract FsController<?> getController(FsMountPoint var1, FsCompositeDriver var2);

    public abstract int getSize();

    @Override
    public abstract Iterator<FsController<?>> iterator();

    public final void sync(BitField<FsSyncOption> options) throws FsSyncException {
        FsSyncExceptionBuilder builder = new FsSyncExceptionBuilder();
        this.sync(options, builder);
        builder.check();
    }

    public <X extends IOException> void sync(final BitField<FsSyncOption> options, final ExceptionHandler<? super IOException, X> handler) throws X {
        if (options.get(FsSyncOption.FORCE_CLOSE_OUTPUT) && !options.get(FsSyncOption.FORCE_CLOSE_INPUT) || options.get(FsSyncOption.ABORT_CHANGES)) {
            throw new IllegalArgumentException();
        }
        class Sync
        implements Visitor {
            Sync() {
            }

            @Override
            public void visit(FsController<?> controller) throws IOException {
                controller.sync(options, handler);
            }
        }
        this.visit(new Sync(), handler);
    }

    private <X extends IOException> void visit(Visitor visitor, ExceptionHandler<? super IOException, X> handler) throws X {
        for (FsController<?> controller : this) {
            try {
                visitor.visit(controller);
            }
            catch (IOException ex) {
                handler.warn(ex);
            }
        }
    }

    public final boolean equals(Object that) {
        return this == that;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + "[size=" + this.getSize() + ']';
    }

    private static interface Visitor {
        public void visit(FsController<?> var1) throws IOException;
    }
}

