/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.client.methods;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.jackrabbit.commons.xml.SerializingContentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlRequestEntity
implements RequestEntity {
    private static Logger log = LoggerFactory.getLogger(XmlRequestEntity.class);
    private final ByteArrayOutputStream xml = new ByteArrayOutputStream();

    public XmlRequestEntity(Document xmlDocument) throws IOException {
        try {
            DefaultHandler handler = SerializingContentHandler.getSerializer((OutputStream)this.xml);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(new DOMSource(xmlDocument), new SAXResult(handler));
        }
        catch (TransformerException e) {
            log.error(e.getMessage());
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            log.error(e.getMessage());
            throw new IOException(e.getMessage());
        }
    }

    public boolean isRepeatable() {
        return true;
    }

    public String getContentType() {
        return "text/xml; charset=UTF-8";
    }

    public void writeRequest(OutputStream out) throws IOException {
        this.xml.writeTo(out);
    }

    public long getContentLength() {
        return this.xml.size();
    }
}

