/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.generic.deployed;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.deployment.planning.Create;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.planning.Destroy;
import com.xebialabs.deployit.plugin.api.deployment.planning.Modify;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.DeployableArtifact;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.validation.Placeholders;
import com.xebialabs.deployit.plugin.generic.deployed.AbstractDeployedArtifact;
import com.xebialabs.deployit.plugin.generic.step.ArtifactCopyStep;
import com.xebialabs.deployit.plugin.generic.step.ArtifactDeleteStep;
import com.xebialabs.deployit.plugin.generic.step.SuccessStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import com.xebialabs.overthere.OverthereFile;
import java.util.Map;

@Metadata(virtual=true, description="An artifact deployed on a generic container")
@Placeholders
public class CopiedArtifact<D extends DeployableArtifact>
extends AbstractDeployedArtifact<D>
implements DerivedArtifact<D> {
    private boolean useDescriptionGeneratedByStep = false;
    private OverthereFile placeholderProcessedFile;
    @Property(defaultValue="false", required=false, hidden=true, description="if true, preserve the existing files on the remote host (do not delete the copied files during the destroy operation). ")
    private boolean preserveExistingFiles;
    @Property(description="A Map containing all the placeholders mapped to their values. Special values are &lt;ignore&gt; or &lt;empty&gt;", required=false)
    private Map<String, String> placeholders = Maps.newHashMap();

    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }

    public void setPlaceholders(Map<String, String> placeholders) {
        this.placeholders = placeholders;
    }

    public OverthereFile getFile() {
        return this.placeholderProcessedFile;
    }

    public void setFile(OverthereFile file) {
        this.placeholderProcessedFile = file;
    }

    public D getSourceArtifact() {
        return (D)((DeployableArtifact)this.getDeployable());
    }

    @Create
    public void executeCreate(DeploymentPlanningContext ctx, Delta delta) {
        ArtifactCopyStep step = this.createArtifactCopyStep();
        ctx.addStepWithCheckpoint((Step)step, delta, Operation.CREATE);
    }

    protected ArtifactCopyStep createArtifactCopyStep() {
        ArtifactCopyStep step = new ArtifactCopyStep(this.getCreateOrder(), this.getFile(), (HostContainer)this.getContainer(), this.getTargetDirectory());
        step.setCreateTargetPath(this.isCreateTargetDirectory());
        step.setTargetFileName(this.resolveTargetFileName());
        step.setSourceFileDescription(((DeployableArtifact)this.getDeployable()).getName());
        step.setPreserveExistingFiles(this.preserveExistingFiles);
        if (!this.useDescriptionGeneratedByStep) {
            step.setDescription(this.getDescription(this.getCreateVerb()));
        }
        return step;
    }

    @Modify
    public void executeModify(DeploymentPlanningContext ctx, Delta delta) {
        CopiedArtifact old = (CopiedArtifact)delta.getPrevious();
        old.executeDestroy(ctx, delta);
        this.executeCreate(ctx, delta);
    }

    @Destroy
    public void executeDestroy(DeploymentPlanningContext ctx, Delta delta) {
        Object step = !this.preserveExistingFiles ? this.createArtifactDeleteStep() : new SuccessStep(this.getDestroyOrder(), String.format("Preserve the existing files %s on %s", this.getTargetDirectory(), this.getContainer()));
        ctx.addStepWithCheckpoint((Step)step, delta, Operation.DESTROY);
    }

    protected ArtifactDeleteStep createArtifactDeleteStep() {
        ArtifactDeleteStep step = new ArtifactDeleteStep(this.getDestroyOrder(), (HostContainer)this.getContainer(), (DeployableArtifact)this.getDeployable(), this.getTargetDirectory());
        step.setTargetDirectoryShared(this.isTargetDirectoryShared());
        step.setTargetFile(this.resolveTargetFileName());
        if (!this.useDescriptionGeneratedByStep) {
            step.setDescription(this.getDescription(this.getDestroyVerb()));
        }
        return step;
    }

    public void setUseDescriptionGeneratedByStep(boolean useDescriptionGeneratedByStep) {
        this.useDescriptionGeneratedByStep = useDescriptionGeneratedByStep;
    }
}

