/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.deployment.orchestrator;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.xebialabs.deployit.engine.spi.orchestration.Orchestration;
import com.xebialabs.deployit.engine.spi.orchestration.Orchestrations;
import com.xebialabs.deployit.engine.spi.orchestration.Orchestrator;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import java.util.Collection;
import java.util.List;

@Orchestrator.Metadata(name="container-by-container-serial")
public class ContainerByContainerOrchestrator
implements Orchestrator {
    public Orchestration orchestrate(DeltaSpecification specification) {
        List deltas = specification.getDeltas();
        Function<Delta, Container> deltaToContainer = new Function<Delta, Container>(){

            public Container apply(Delta input) {
                return (Container)ContainerByContainerOrchestrator.this.getDeployed(input).getContainer();
            }
        };
        Function<Collection<Delta>, Orchestration> deltasToPlan = new Function<Collection<Delta>, Orchestration>(){

            public Orchestration apply(Collection<Delta> input) {
                return Orchestrations.interleaved((List)Lists.newArrayList(input));
            }
        };
        return Orchestrations.serial((List)Lists.newArrayList((Iterable)Iterables.transform((Iterable)Multimaps.index((Iterable)deltas, (Function)deltaToContainer).asMap().values(), (Function)deltasToPlan)));
    }

    private Deployed<?, ?> getDeployed(Delta input) {
        return input.getDeployed() != null ? input.getDeployed() : input.getPrevious();
    }
}

