/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.apache.jackrabbit.commons.iterator.FrozenNodeIteratorAdapter;
import org.apache.jackrabbit.core.AbstractNodeData;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.version.InternalVersion;
import org.apache.jackrabbit.core.version.InternalVersionHistory;
import org.apache.jackrabbit.core.version.VersionImpl;
import org.apache.jackrabbit.core.version.VersionIteratorImpl;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionHistoryImpl
extends NodeImpl
implements VersionHistory {
    private static Logger log = LoggerFactory.getLogger(VersionHistoryImpl.class);

    public VersionHistoryImpl(ItemManager itemMgr, SessionContext sessionContext, AbstractNodeData data) {
        super(itemMgr, sessionContext, data);
    }

    protected InternalVersionHistory getInternalVersionHistory() throws RepositoryException {
        SessionImpl session = this.sessionContext.getSessionImpl();
        InternalVersionHistory history = session.getInternalVersionManager().getVersionHistory((NodeId)this.id);
        if (history == null) {
            throw new InvalidItemStateException(this.id + ": the item does not exist anymore");
        }
        return history;
    }

    public Version getRootVersion() throws RepositoryException {
        SessionImpl session = this.sessionContext.getSessionImpl();
        return (Version)session.getNodeById(this.getInternalVersionHistory().getRootVersion().getId());
    }

    public VersionIterator getAllVersions() throws RepositoryException {
        return new VersionIteratorImpl(this.getSession(), this.getInternalVersionHistory().getRootVersion());
    }

    public NodeIterator getAllFrozenNodes() throws RepositoryException {
        return new FrozenNodeIteratorAdapter(this.getAllVersions());
    }

    public VersionIterator getAllLinearVersions() throws RepositoryException {
        SessionImpl session = this.sessionContext.getSessionImpl();
        InternalVersionHistory vh = this.getInternalVersionHistory();
        NodeImpl vn = session.getNodeById(vh.getVersionableId());
        InternalVersion base = ((VersionImpl)vn.getBaseVersion()).getInternalVersion();
        return new VersionIteratorImpl(this.getSession(), vh.getRootVersion(), base);
    }

    public NodeIterator getAllLinearFrozenNodes() throws RepositoryException {
        return new FrozenNodeIteratorAdapter(this.getAllLinearVersions());
    }

    public Version getVersion(String versionName) throws VersionException, RepositoryException {
        try {
            Name name = this.sessionContext.getQName(versionName);
            InternalVersion v = this.getInternalVersionHistory().getVersion(name);
            if (v == null) {
                throw new VersionException("No version with name '" + versionName + "' exists in this version history.");
            }
            return (Version)this.sessionContext.getSessionImpl().getNodeById(v.getId());
        }
        catch (NameException e) {
            throw new VersionException((Throwable)e);
        }
    }

    public Version getVersionByLabel(String label) throws RepositoryException {
        try {
            Name qLabel = this.sessionContext.getQName(label);
            InternalVersion v = this.getInternalVersionHistory().getVersionByLabel(qLabel);
            if (v == null) {
                throw new VersionException("No version with label '" + label + "' exists in this version history.");
            }
            return (Version)this.sessionContext.getSessionImpl().getNodeById(v.getId());
        }
        catch (NameException e) {
            throw new VersionException((Throwable)e);
        }
    }

    public void addVersionLabel(String versionName, String label, boolean move) throws VersionException, RepositoryException {
        try {
            this.checkVersionManagementPermission();
            this.sessionContext.getSessionImpl().getInternalVersionManager().setVersionLabel(this.getSession(), this.getInternalVersionHistory(), this.sessionContext.getQName(versionName), this.sessionContext.getQName(label), move);
        }
        catch (NameException e) {
            throw new VersionException((Throwable)e);
        }
    }

    public void removeVersionLabel(String label) throws RepositoryException {
        try {
            this.checkVersionManagementPermission();
            InternalVersion existing = this.sessionContext.getSessionImpl().getInternalVersionManager().setVersionLabel(this.getSession(), this.getInternalVersionHistory(), null, this.sessionContext.getQName(label), true);
            if (existing == null) {
                throw new VersionException("No version with label '" + label + "' exists in this version history.");
            }
        }
        catch (NameException e) {
            throw new VersionException((Throwable)e);
        }
    }

    public String[] getVersionLabels() throws RepositoryException {
        Name[] labels = this.getInternalVersionHistory().getVersionLabels();
        String[] ret = new String[labels.length];
        for (int i = 0; i < labels.length; ++i) {
            ret[i] = this.sessionContext.getJCRName(labels[i]);
        }
        return ret;
    }

    public String[] getVersionLabels(Version version) throws VersionException, RepositoryException {
        this.checkOwnVersion(version);
        Name[] labels = ((VersionImpl)version).getInternalVersion().getLabels();
        String[] ret = new String[labels.length];
        for (int i = 0; i < labels.length; ++i) {
            ret[i] = this.sessionContext.getJCRName(labels[i]);
        }
        return ret;
    }

    public boolean hasVersionLabel(String label) throws RepositoryException {
        try {
            Name qLabel = this.sessionContext.getQName(label);
            return this.getInternalVersionHistory().getVersionByLabel(qLabel) != null;
        }
        catch (NameException e) {
            throw new IllegalArgumentException("Unable to resolve label: " + (Object)((Object)e));
        }
    }

    public boolean hasVersionLabel(Version version, String label) throws VersionException, RepositoryException {
        this.checkOwnVersion(version);
        try {
            Name qLabel = this.sessionContext.getQName(label);
            return ((VersionImpl)version).getInternalVersion().hasLabel(qLabel);
        }
        catch (NameException e) {
            throw new VersionException((Throwable)e);
        }
    }

    public void removeVersion(String versionName) throws UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        try {
            this.checkVersionManagementPermission();
            this.sessionContext.getSessionImpl().getInternalVersionManager().removeVersion(this.getSession(), this.getInternalVersionHistory(), this.sessionContext.getQName(versionName));
        }
        catch (NameException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public boolean isSame(Item otherItem) {
        if (otherItem instanceof VersionHistoryImpl) {
            try {
                InternalVersionHistory other = ((VersionHistoryImpl)otherItem).getInternalVersionHistory();
                return other.getId().equals(this.getInternalVersionHistory().getId());
            }
            catch (RepositoryException e) {
                log.warn("Unable to retrieve internal version history objects: " + e.getMessage());
                log.debug("Stack dump:", (Throwable)e);
            }
        }
        return false;
    }

    public String getVersionableUUID() throws RepositoryException {
        return this.getVersionableIdentifier();
    }

    public String getVersionableIdentifier() throws RepositoryException {
        return this.getInternalVersionHistory().getVersionableId().toString();
    }

    private void checkVersionManagementPermission() throws RepositoryException {
        try {
            this.sessionContext.getAccessManager().checkPermission(this.getPrimaryPath(), 256);
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
    }

    private void checkOwnVersion(Version version) throws VersionException, RepositoryException {
        if (!version.getParent().isSame((Item)this)) {
            throw new VersionException("Specified version not contained in this history.");
        }
    }

    public void update(String srcWorkspaceName) throws ConstraintViolationException {
        String msg = "update operation not allowed: " + this;
        log.debug(msg);
        throw new ConstraintViolationException(msg);
    }

    public NodeIterator merge(String srcWorkspace, boolean bestEffort) throws ConstraintViolationException {
        String msg = "merge operation not allowed: " + this;
        log.debug(msg);
        throw new ConstraintViolationException(msg);
    }

    public String toString() {
        return "version history " + super.toString();
    }
}

