/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.validator.css;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.batik.css.parser.ParseException;
import org.apache.batik.css.parser.Parser;
import org.owasp.validator.css.CssHandler;
import org.owasp.validator.css.ExternalCssScanner;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;
import org.owasp.validator.html.ScanException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;

public class CssScanner {
    protected static final int DEFAULT_TIMEOUT = 1000;
    private static final String CDATA = "^\\s*<!\\[CDATA\\[(.*)\\]\\]>\\s*$";
    protected final Parser parser = new Parser();
    protected final Policy policy;
    protected final ResourceBundle messages;

    public CssScanner(Policy policy, ResourceBundle messages) {
        this.policy = policy;
        this.messages = messages;
    }

    public CleanResults scanStyleSheet(String taintedCss, int sizeLimit) throws ScanException {
        Date startOfScan = new Date();
        ArrayList errorMessages = new ArrayList();
        Pattern p = Pattern.compile(CDATA, 32);
        Matcher m = p.matcher(taintedCss);
        boolean isCdata = m.matches();
        if (isCdata) {
            taintedCss = m.group(1);
        }
        LinkedList stylesheets = new LinkedList();
        CssHandler handler = new CssHandler(this.policy, stylesheets, errorMessages, this.messages);
        this.parser.setDocumentHandler((DocumentHandler)handler);
        try {
            this.parser.parseStyleSheet(new InputSource((Reader)new StringReader(taintedCss)));
        }
        catch (IOException ioe) {
            throw new ScanException(ioe);
        }
        catch (ParseException pe) {
            throw new ScanException((Exception)((Object)pe));
        }
        this.parseImportedStylesheets(stylesheets, handler, errorMessages, sizeLimit);
        String cleaned = handler.getCleanStylesheet();
        if (isCdata && !"true".equals(this.policy.getDirective("useXHTML"))) {
            cleaned = "<![CDATA[[" + cleaned + "]]>";
        }
        return new CleanResults(startOfScan, new Date(), cleaned, null, errorMessages);
    }

    public CleanResults scanInlineStyle(String taintedCss, String tagName, int sizeLimit) throws ScanException {
        Date startOfScan = new Date();
        ArrayList errorMessages = new ArrayList();
        LinkedList stylesheets = new LinkedList();
        CssHandler handler = new CssHandler(this.policy, stylesheets, errorMessages, tagName, this.messages);
        this.parser.setDocumentHandler((DocumentHandler)handler);
        try {
            this.parser.parseStyleDeclaration(taintedCss);
        }
        catch (IOException ioe) {
            throw new ScanException(ioe);
        }
        this.parseImportedStylesheets(stylesheets, handler, errorMessages, sizeLimit);
        return new CleanResults(startOfScan, new Date(), handler.getCleanStylesheet(), null, errorMessages);
    }

    protected void parseImportedStylesheets(LinkedList stylesheets, CssHandler handler, ArrayList errorMessages, int sizeLimit) throws ScanException {
    }

    public static void main(String[] args) throws Exception {
        Policy policy = Policy.getInstance("resources/antisamy-1.2.xml");
        CssScanner scanner = null;
        scanner = "true".equals(policy.getDirective("embedStyleSheets")) ? new ExternalCssScanner(policy, ResourceBundle.getBundle("AntiSamy", Locale.getDefault())) : new CssScanner(policy, ResourceBundle.getBundle("AntiSamy", Locale.getDefault()));
        CleanResults results = null;
        results = scanner.scanStyleSheet("@import url(http://www.owasp.org/skins/monobook/main.css);@import url(http://www.w3schools.com/stdtheme.css);@import url(http://www.google.com/ig/f/t1wcX5O39cc/ig.css); ", Integer.MAX_VALUE);
        System.out.println("Cleaned result:");
        System.out.println(results.getCleanHTML());
        System.out.println("--");
        System.out.println("Error messages");
        System.out.println(results.getErrorMessages());
    }
}

