/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive;

import de.schlichtherle.truezip.entry.DecoratingEntry;
import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsConcurrentModel;
import de.schlichtherle.truezip.fs.FsConcurrentModelController;
import de.schlichtherle.truezip.fs.FsEntry;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsEntryNotFoundException;
import de.schlichtherle.truezip.fs.FsFalsePositiveException;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsNotSyncedException;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.archive.FsArchiveEntry;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystem;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystemOperation;
import de.schlichtherle.truezip.fs.archive.FsCovariantEntry;
import de.schlichtherle.truezip.fs.archive.FsOperationContext;
import de.schlichtherle.truezip.io.InputException;
import de.schlichtherle.truezip.io.Streams;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
abstract class FsArchiveController<E extends FsArchiveEntry>
extends FsConcurrentModelController {
    private static final Logger logger = Logger.getLogger(FsArchiveController.class.getName(), FsArchiveController.class.getName());
    private final ThreadLocal<FsOperationContext> context = new ThreadLocal();

    FsArchiveController(FsConcurrentModel model) {
        super(model);
        if (null == model.getParent()) {
            throw new IllegalArgumentException();
        }
    }

    final FsOperationContext getContext() {
        return this.context.get();
    }

    final void setContext(@CheckForNull FsOperationContext context) {
        if (null != context) {
            this.context.set(context);
        } else {
            this.context.remove();
        }
    }

    final FsArchiveFileSystem<E> autoMount() throws IOException {
        return this.autoMount(false);
    }

    abstract FsArchiveFileSystem<E> autoMount(boolean var1) throws IOException;

    @Override
    public final boolean isReadOnly() throws IOException {
        return this.autoMount().isReadOnly();
    }

    @Override
    public final FsEntry getEntry(FsEntryName name) throws IOException {
        return this.autoMount().getEntry(name);
    }

    @Override
    public final boolean isReadable(FsEntryName name) throws IOException {
        return this.autoMount().getEntry(name) != null;
    }

    @Override
    public final boolean isWritable(FsEntryName name) throws IOException {
        return this.autoMount().isWritable(name);
    }

    @Override
    public final void setReadOnly(FsEntryName name) throws IOException {
        this.autoMount().setReadOnly(name);
    }

    @Override
    public final boolean setTime(FsEntryName name, Map<Entry.Access, Long> times, BitField<FsOutputOption> options) throws IOException {
        this.checkAccess(name, null);
        return this.autoMount().setTime(name, times);
    }

    @Override
    public final boolean setTime(FsEntryName name, BitField<Entry.Access> types, long value, BitField<FsOutputOption> options) throws IOException {
        this.checkAccess(name, null);
        return this.autoMount().setTime(name, types, value);
    }

    @Override
    public final InputSocket<?> getInputSocket(FsEntryName name, BitField<FsInputOption> options) {
        return new ArchiveInputSocket(name);
    }

    abstract InputSocket<?> getInputSocket(String var1);

    @Override
    public final OutputSocket<?> getOutputSocket(FsEntryName name, BitField<FsOutputOption> options, Entry template) {
        return new ArchiveOutputSocket(name, options, template);
    }

    abstract OutputSocket<?> getOutputSocket(E var1);

    @Override
    public final void mknod(FsEntryName name, Entry.Type type, BitField<FsOutputOption> options, Entry template) throws IOException {
        assert (options.equals(this.getContext().getOutputOptions()));
        this.checkAccess(name, null);
        if (name.isRoot()) {
            try {
                this.autoMount();
            }
            catch (FsFalsePositiveException ex) {
                if (Entry.Type.DIRECTORY != type) {
                    throw ex;
                }
                this.autoMount(true);
                return;
            }
            throw new FsEntryNotFoundException((FsModel)this.getModel(), name, "directory exists already");
        }
        this.autoMount(options.get(FsOutputOption.CREATE_PARENTS)).mknod(name, type, options, template).run();
    }

    @Override
    public void unlink(FsEntryName name, BitField<FsOutputOption> options) throws IOException {
        this.checkAccess(name, null);
        FsArchiveFileSystem<E> fileSystem = this.autoMount();
        if (name.isRoot()) {
            if (!fileSystem.getEntry(FsEntryName.ROOT).getMembers().isEmpty()) {
                throw new IOException("root directory not empty");
            }
            if (1 < fileSystem.getSize()) {
                logger.log(Level.WARNING, "unlink.absolute", new Object[]{fileSystem.getSize() - 1, this.getMountPoint()});
            }
        } else {
            fileSystem.unlink(name);
        }
    }

    abstract void checkAccess(FsEntryName var1, @CheckForNull Entry.Access var2) throws FsNotSyncedException;

    private static final class ProxyEntry
    extends DecoratingEntry<FsArchiveEntry>
    implements FsArchiveEntry {
        ProxyEntry(FsArchiveEntry entry) {
            super(entry);
        }

        @Override
        public Entry.Type getType() {
            return ((FsArchiveEntry)this.delegate).getType();
        }

        @Override
        public boolean setSize(Entry.Size type, long value) {
            return ((FsArchiveEntry)this.delegate).setSize(type, value);
        }

        @Override
        public boolean setTime(Entry.Access type, long value) {
            return ((FsArchiveEntry)this.delegate).setTime(type, value);
        }
    }

    private final class ArchiveOutputSocket
    extends OutputSocket<FsArchiveEntry> {
        final FsEntryName name;
        final boolean append;
        @CheckForNull
        final Entry template;

        ArchiveOutputSocket(FsEntryName name, @CheckForNull BitField<FsOutputOption> options, Entry template) {
            this.name = name;
            this.append = options.get(FsOutputOption.APPEND);
            this.template = template;
        }

        FsArchiveFileSystemOperation<E> mknod() throws IOException {
            FsArchiveController.this.checkAccess(this.name, Entry.Access.WRITE);
            BitField<FsOutputOption> options = FsArchiveController.this.getContext().getOutputOptions();
            return FsArchiveController.this.autoMount(!this.name.isRoot() && options.get(FsOutputOption.CREATE_PARENTS)).mknod(this.name, Entry.Type.FILE, options, this.template);
        }

        @Override
        public FsArchiveEntry getLocalTarget() throws IOException {
            Object entry = ((FsCovariantEntry)this.mknod().getTarget()).getEntry();
            if (this.append) {
                return new ProxyEntry((FsArchiveEntry)entry);
            }
            return entry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public OutputStream newOutputStream() throws IOException {
            InputStream in = null;
            if (this.append) {
                try {
                    in = new ArchiveInputSocket(this.name).newInputStream();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            try {
                FsArchiveFileSystemOperation mknod = this.mknod();
                Object entry = ((FsCovariantEntry)mknod.getTarget()).getEntry();
                OutputStream out = FsArchiveController.this.getOutputSocket(entry).bind(null == in ? this : null).newOutputStream();
                try {
                    mknod.run();
                    if (in != null) {
                        Streams.cat(in, out);
                    }
                }
                catch (IOException ex) {
                    out.close();
                    throw ex;
                }
                OutputStream outputStream = out;
                return outputStream;
            }
            finally {
                if (null != in) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {
                        throw new InputException(ex);
                    }
                }
            }
        }
    }

    private final class ArchiveInputSocket
    extends InputSocket<FsArchiveEntry> {
        final FsEntryName name;

        ArchiveInputSocket(FsEntryName name) {
            this.name = name;
        }

        @Override
        public FsArchiveEntry getLocalTarget() throws IOException {
            this.getPeerTarget();
            FsArchiveController.this.checkAccess(this.name, Entry.Access.READ);
            FsCovariantEntry entry = FsArchiveController.this.autoMount().getEntry(this.name);
            if (null == entry) {
                throw new FsEntryNotFoundException((FsModel)FsArchiveController.this.getModel(), this.name, "no such file or directory");
            }
            return entry.getEntry();
        }

        InputSocket<?> getBoundSocket() throws IOException {
            FsArchiveEntry entry = this.getLocalTarget();
            if (Entry.Type.FILE != entry.getType()) {
                throw new FsEntryNotFoundException((FsModel)FsArchiveController.this.getModel(), this.name, "cannot read directories");
            }
            return FsArchiveController.this.getInputSocket(entry.getName()).bind(this);
        }

        @Override
        public ReadOnlyFile newReadOnlyFile() throws IOException {
            return this.getBoundSocket().newReadOnlyFile();
        }

        @Override
        public SeekableByteChannel newSeekableByteChannel() throws IOException {
            return this.getBoundSocket().newSeekableByteChannel();
        }

        @Override
        public InputStream newInputStream() throws IOException {
            return this.getBoundSocket().newInputStream();
        }
    }
}

