/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.io;

import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplateHolder;
import com.xebialabs.deployit.plugin.api.udm.artifact.FolderArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalConnection;
import com.xebialabs.overthere.local.LocalFile;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;

public class SourceArtifactFile {
    private static final Class<LocalFile> proxyClass = SourceArtifactFile.createProxyClass();

    private SourceArtifactFile() {
    }

    private static Class<LocalFile> createProxyClass() {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setSuperclass(LocalFile.class);
        proxyFactory.setUseCache(false);
        proxyFactory.setUseWriteReplace(false);
        return proxyFactory.createClass();
    }

    public static LocalFile create(SourceArtifact artifact, String filename, JcrCallback<LocalFile> readToDiskCallable) {
        try {
            Constructor<LocalFile> constructor = proxyClass.getConstructor(LocalConnection.class, File.class);
            LocalFile o = constructor.newInstance(LocalConnection.getLocalConnection(), null);
            ((ProxyObject)o).setHandler(SourceArtifactFile.getMethodHandler(artifact, filename, readToDiskCallable));
            return o;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create a proxy.", e);
        }
    }

    private static MethodHandler getMethodHandler(SourceArtifact artifact, String filename, JcrCallback<LocalFile> readToDiskCallable) {
        return new DerivedFileHandler(artifact, filename, readToDiskCallable);
    }

    public static class DerivedFileHandler
    implements MethodHandler,
    Serializable {
        private SourceArtifact artifact;
        private String filename;
        private JcrCallback<LocalFile> readToDiskCallable;

        public DerivedFileHandler(SourceArtifact artifact, String filename, JcrCallback<LocalFile> readToDiskCallback) {
            this.artifact = artifact;
            this.filename = filename;
            this.readToDiskCallable = readToDiskCallback;
        }

        public synchronized Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
            if (ProxyFactory.isProxyClass(this.artifact.getFile().getClass())) {
                if (thisMethod.getName().equals("getName")) {
                    return this.filename;
                }
                if (thisMethod.getName().equals("exists")) {
                    return true;
                }
                if (thisMethod.getName().equals("isFile")) {
                    return !(this.artifact instanceof FolderArtifact);
                }
                if (thisMethod.getName().equals("isDirectory")) {
                    return this.artifact instanceof FolderArtifact;
                }
                LocalFile lf = JcrTemplateHolder.get().execute(this.readToDiskCallable, true);
                this.artifact.setFile((OverthereFile)lf);
            }
            return thisMethod.invoke((Object)this.artifact.getFile(), args);
        }
    }
}

